package edu.hust.go.term;

/**
 * <p>Title: GO4J</p>
 * <p>Description: Go api in Java</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: Life Science and Technology, HUST, China</p>
 * @author GQ Zhang
 * @version 1.0
 */

import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import javax.xml.transform.TransformerException;
import org.apache.xpath.CachedXPathAPI;

public class OboXmlGo_term extends DefaultGO_term{
    String namespace;
    Def definition;
    Vector alt_id = new Vector();
    Vector subset = new Vector();
    String comment;
    boolean is_anonymous;
    boolean is_obsolete;
    boolean is_root;
    Vector xref_analog = new Vector();
    Vector xref_unknown = new Vector();
    Vector synonym = new Vector();
    Vector relationship = new Vector();
    Vector intersection_of = new Vector();
    Vector union_of = new Vector();
    String lexical_category;

    public OboXmlGo_term(Document doc) throws TransformerException {
        CachedXPathAPI xpath = new CachedXPathAPI();
        id = xpath.eval(doc, "/term/id").str();
        name = xpath.eval(doc, "/term/name").str();
        namespace = xpath.eval(doc, "/term/namespace").str();
        definition = new Def(doc, xpath);
        is_a = setVector(doc, xpath, "/term/is_a");
        alt_id = setVector(doc, xpath, "/term/alt_id");
        subset = setVector(doc, xpath, "/term/subset");
        comment = xpath.eval(doc, "/term/comment").str();
        is_anonymous = setBool(doc, xpath, "/term/is_anonymous");
        is_obsolete = setBool(doc, xpath, "/term/is_obsolete");
        is_root = setBool(doc, xpath, "/term/is_root");
        xref_analog = setXref(xpath.selectNodeList(doc, "/term/xref_analog"), xpath);
        xref_unknown = setXref(xpath.selectNodeList(doc, "/term/xref_unknown"), xpath);
        synonym = setSynonym(doc, xpath);
        relationship = setRelationship(doc, xpath, "/term/relationship");
        intersection_of = setRelationship(doc, xpath, "/term/intersection_of");
        union_of = setVector(doc, xpath, "/term/union_of");
        lexical_category = xpath.eval(doc, "/term/lexical_category").str();
        refine();
    }

    private void refine(){
        def=definition.defStr;
        for(int i=0;i<relationship.size();i++){
            String[] array=(String[])relationship.get(i);
            if(array[0].equals("part_of")){
                part_of.add(array[1]);
            }
        }
    }

    Vector setVector(Document doc, CachedXPathAPI xpath, String xqueryStr) throws TransformerException {
        Vector vector = new Vector();
        NodeList list = xpath.selectNodeList(doc, xqueryStr);
        for (int i = 0; i < list.getLength(); i++) {
            vector.add(xpath.eval(list.item(i), ".").str());
        }
        return vector;
    }

    boolean setBool(Document doc, CachedXPathAPI xpath, String xqueryStr) throws TransformerException {
        String str = xpath.eval(doc, xqueryStr).str();
        return str.equals("1") || str.equals("true") || str.equals("yes");
    }

    Vector setXref(NodeList nodeList, CachedXPathAPI xpath) throws TransformerException {
        Vector vector = new Vector();
        for (int i = 0; i < nodeList.getLength(); i++) {
            Node node = nodeList.item(i);
            String dbname = xpath.eval(node, "dbname").str();
            String name = xpath.eval(node, "name").str();
            String acc = xpath.eval(node, "acc").str();
            String[] array = {
                dbname, acc, name};
            vector.add(array);
        }
        return vector;
    }

    Vector setSynonym(Document doc, CachedXPathAPI xpath) throws TransformerException {
        Vector vector = new Vector();
        NodeList nodeList = xpath.selectNodeList(doc, "/term/synonym");
        for (int i = 0; i < nodeList.getLength(); i++) {
            vector.add(new Synonym(nodeList.item(i), xpath));
        }
        return vector;
    }

    Vector setRelationship(Document doc, CachedXPathAPI xpath, String xqueryStr) throws TransformerException {
        Vector vector = new Vector();
        NodeList nodeList = xpath.selectNodeList(doc, xqueryStr);
        for (int i = 0; i < nodeList.getLength(); i++) {
            Node node = nodeList.item(i);
            String type = xpath.eval(node, "type").str();
            String to = xpath.eval(node, "to").str();
            String[] array = {
                type, to};
            vector.add(array);
        }
        return vector;
    }

    public Vector getAlt_id() {
        return alt_id;
    }

    public String getComment() {
        return comment;
    }

    public Def getDefinition() {
        return definition;
    }

    public Vector getIntersection_of() {
        return intersection_of;
    }

    public boolean isIs_anonymous() {
        return is_anonymous;
    }

    public boolean isIs_obsolete() {
        return is_obsolete;
    }

    public boolean isIs_root() {
        return is_root;
    }

    public String getLexical_category() {
        return lexical_category;
    }

    public Vector getRelationship() {
        return relationship;
    }

    public String getNamespace() {
        return namespace;
    }

    public Vector getSubset() {
        return subset;
    }

    public Vector getSynonym() {
        return synonym;
    }

    public Vector getUnion_of() {
        return union_of;
    }

    public Vector getXref_analog() {
        return xref_analog;
    }

    public Vector getXref_unknown() {
        return xref_unknown;
    }

    class Def {
        String defStr = "";
        Vector dbxref = new Vector();
        public Def(Document doc, CachedXPathAPI xpath) throws TransformerException {
            Node node = xpath.selectSingleNode(doc, "/term/def");
            if (node != null) {
                defStr = xpath.eval(node, "defstr").str();
                NodeList list = xpath.selectNodeList(node, "dbxref");
                Vector dbxref = setXref(list, xpath);
            }
        }
    }

    class Synonym {
        String scope;
        String text;
        Vector dbxref = new Vector();
        public Synonym(Node node, CachedXPathAPI xpath) throws TransformerException {
            scope = xpath.eval(node, "./@scope").str();
            text = xpath.eval(node, "./synonym_text").str();
            NodeList list = xpath.selectNodeList(node, "dbxref");
            Vector dbxref = setXref(list, xpath);
        }
    }

}