package edu.hust.go.term;

/**
 * <p>Title: GO4J</p>
 * <p>Description: Go api in Java</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: Life Science and Technology, HUST, China</p>
 * @author GQ Zhang
 * @version 1.0
 */
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import javax.xml.transform.TransformerException;
import org.apache.xpath.CachedXPathAPI;

public class RdfXmlGo_term
    extends DefaultGO_term {
    Vector synonym = new Vector();
    Vector comment = new Vector();
    Vector dbxref = new Vector();
    Vector association = new Vector();
    Vector history = new Vector();
    boolean is_obsolete;

    boolean focus;
    int n_associations;

    public RdfXmlGo_term(Document doc) throws TransformerException {
        CachedXPathAPI xpath = new CachedXPathAPI();
        is_obsolete = setBool(doc, xpath, "/term/is_obsolete");
        focus = setBool(doc, xpath, "/term/@focus");
        n_associations = (int) xpath.eval(doc, "/term/@n_associations").num();
        id = xpath.eval(doc, "/term/accession").str();
        name = xpath.eval(doc, "/term/accession").str();
        synonym = setVector(doc, xpath, "/term/synonym");
        def = xpath.eval(doc, "/term/definition").str();
        comment = setVector(doc, xpath, "/term/synonym");
        part_of = setAttrVector(doc, xpath, "/term/part_of");
        is_a = setAttrVector(doc, xpath, "/term/is_a");
        dbxref = setDbxref(doc, xpath);
        association = setAssociation(doc, xpath);
        history = setHistory(doc, xpath);
    }

    Vector setVector(Document doc, CachedXPathAPI xpath, String xqueryStr) throws TransformerException {
        Vector vector = new Vector();
        NodeList list = xpath.selectNodeList(doc, xqueryStr);
        for (int i = 0; i < list.getLength(); i++) {
            vector.add(xpath.eval(list.item(i), ".").str());
        }
        return vector;
    }

    Vector setAttrVector(Document doc, CachedXPathAPI xpath, String xqueryStr) throws TransformerException {
        Vector vector = new Vector();
        NodeList list = xpath.selectNodeList(doc, xqueryStr);
        for (int i = 0; i < list.getLength(); i++) {
            String str = xpath.eval(list.item(i), "./@resource").str();
            if (str.indexOf("#") > -1) {
                str = str.substring(str.indexOf("#") + 1);
                if (str.startsWith("GO:")) {
                    vector.add(str);
                }
                else if (str.startsWith("obsolete")) {
                    is_obsolete = true;
                }
            }
        }
        return vector;
    }

    Vector setDbxref(Document doc, CachedXPathAPI xpath) throws TransformerException {
        Vector vector = new Vector();
        NodeList list = xpath.selectNodeList(doc, "/term/dbxref");
        for (int i = 0; i < list.getLength(); i++) {
            vector.add(setDbxref(list.item(i), xpath));
        }
        return vector;
    }

    String[] setDbxref(Node node, CachedXPathAPI xpath) throws TransformerException {
        String database_symbol = xpath.eval(node, "database_symbol").str();
        String reference = xpath.eval(node, "reference").str();
        String type = xpath.eval(node, "reference/@type").str();
        String[] array = {
            database_symbol, reference, type};
        return array;
    }

    Vector setAssociation(Document doc, CachedXPathAPI xpath) throws TransformerException {
        Vector vector = new Vector();
        NodeList list = xpath.selectNodeList(doc, "/term/association");
        for (int i = 0; i < list.getLength(); i++) {
            Vector evidenceVector = new Vector();
            Node node = list.item(i);
            NodeList swapList = xpath.selectNodeList(node, "evidence");
            for (int j = 0; j < swapList.getLength(); j++) {
                String[] array = setDbxref(xpath.selectSingleNode(swapList.item(j), "dbxref"), xpath);
                String evidence_code = xpath.eval(swapList.item(j), "./@evidence_code").str();
                String[] swap = new String[array.length + 1];
                swap[0] = evidence_code;
                System.arraycopy(array, 0, swap, 1, array.length);
                evidenceVector.add(swap);
            }
            vector.add(setDbxref(list.item(i), xpath));
            node = xpath.selectSingleNode(node, "gene_product");
            String[] array = setDbxref(xpath.selectSingleNode(node, "dbxref"), xpath);
            String name = xpath.eval(node, "name").str();
            String[] swap = new String[array.length + 1];
            swap[0] = name;
            System.arraycopy(array, 0, swap, 1, array.length);
            Object[] obj = {
                swap, evidenceVector};
            vector.add(obj);
        }
        return vector;
    }

    Vector setHistory(Document doc, CachedXPathAPI xpath) throws TransformerException {
        Vector vector = new Vector();
        NodeList nodeList = xpath.selectNodeList(doc, "/term/history");
        for (int i = 0; i < nodeList.getLength(); i++) {
            Node node = nodeList.item(i);
            String date = xpath.eval(node, "date").str();
            String person = xpath.eval(node, "person").str();
            String rationale = xpath.eval(node, "rationale").str();
            String status = "";
            String resource = "";
            if (xpath.selectSingleNode(node, "created") != null) {
                status = "created";
            }
            else if (xpath.selectSingleNode(node, "deleted") != null) {
                status = "deleted";
            }
            else if (xpath.eval(node, "split/@resource").str().length() > 0) {
                status = "split";
                resource = xpath.eval(node, "split/@resource").str();
            }
            else if (xpath.eval(node, "merged/@resource").str().length() > 0) {
                status = "merged";
                resource = xpath.eval(node, "merged/@resource").str();
            }
            else if (xpath.eval(node, "moved/@resource").str().length() > 0) {
                status = "moved";
                resource = xpath.eval(node, "moved/@resource").str();
            }
            String obsolete = xpath.eval(node, "./obsolete").str();
            String[] array = {
                date, person, rationale, status, resource, obsolete};
            vector.add(array);
        }
        return vector;
    }

    boolean setBool(Document doc, CachedXPathAPI xpath, String xqueryStr) throws TransformerException {
        String str = xpath.eval(doc, xqueryStr).str();
        return str.equals("1") || str.equals("true") || str.equals("yes");
    }

    public Vector getComment() {
        return comment;
    }

    public Vector getDbxref() {
        return dbxref;
    }

    public boolean isFocus() {
        return focus;
    }

    public Vector getHistory() {
        return history;
    }

    public boolean isIs_obsolete() {
        return is_obsolete;
    }

    public int getN_associations() {
        return n_associations;
    }

    public Vector getSynonym() {
        return synonym;
    }

    public Vector getAssociation() {
        return association;
    }

}