/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.PortView;

public class AttributeMap
extends Hashtable {
    public AttributeMap() {
    }

    public AttributeMap(Map map) {
        super(map);
    }

    public Point2D createPoint() {
        return new SerializablePoint2D();
    }

    public Point2D createPoint(Point2D point2D) {
        if (point2D != null) {
            return this.createPoint(point2D.getX(), point2D.getY());
        }
        return null;
    }

    public Point2D createPoint(double d, double d2) {
        return new SerializablePoint2D(d, d2);
    }

    public Rectangle2D createRect() {
        return new SerializableRectangle2D();
    }

    public Rectangle2D createRect(double d, double d2, double d3, double d4) {
        return new SerializableRectangle2D(d, d2, d3, d4);
    }

    public Rectangle2D createRect(Point2D point2D) {
        return this.createRect(point2D, 0.0);
    }

    public Rectangle2D createRect(Point2D point2D, double d) {
        if (point2D != null) {
            return this.createRect(point2D.getX(), point2D.getY(), d, d);
        }
        return null;
    }

    public Rectangle2D createRect(Rectangle2D rectangle2D) {
        if (rectangle2D != null) {
            return this.createRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        return null;
    }

    public Rectangle2D createRect(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.createRect(d - d5, d2 - d5, d3 + d5 + d6, d4 + d5 + d6);
    }

    public Rectangle2D createRect(Rectangle2D rectangle2D, double d, double d2) {
        if (rectangle2D != null) {
            return this.createRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), d, d2);
        }
        return null;
    }

    public AttributeMap applyMap(Map map) {
        AttributeMap attributeMap = new AttributeMap();
        if (map != null) {
            Iterator iterator;
            Object[] objectArray;
            if (GraphConstants.isRemoveAll(map)) {
                attributeMap.putAll(this);
                this.clear();
            }
            if ((objectArray = GraphConstants.getRemoveAttributes(map)) != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    iterator = this.remove(objectArray[i]);
                    if (iterator == null) continue;
                    attributeMap.put(objectArray[i], iterator);
                }
            }
            HashSet hashSet = new HashSet();
            iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                if (k.equals("removeAll") || k.equals("removeAttributes")) continue;
                Object object = this.applyValue(k, entry.getValue());
                if (object == null) {
                    hashSet.add(k);
                    continue;
                }
                attributeMap.put(k, object);
            }
            if (!hashSet.isEmpty()) {
                GraphConstants.setRemoveAttributes(attributeMap, hashSet.toArray());
            }
        }
        return attributeMap;
    }

    public Object applyValue(Object object, Object object2) {
        if (object == "value") {
            return this.valueChanged(object2);
        }
        if (object2 instanceof Rectangle2D) {
            object2 = this.createRect((Rectangle2D)object2);
        }
        if (object2 instanceof List) {
            object2 = this.clonePoints((List)object2, false);
        }
        return this.put(object, object2);
    }

    public Object valueChanged(Object object) {
        return this.put("value", object);
    }

    public List clonePoints(List list) {
        return this.clonePoints(list, true);
    }

    public List clonePoints(List list, boolean bl) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof PortView && bl) {
                object = ((PortView)object).getLocation(null);
            } else if (object instanceof Point2D) {
                object = this.createPoint((Point2D)object);
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    public static void translate(Collection collection, double d, double d2) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof AttributeMap)) continue;
            ((AttributeMap)e).translate(d, d2);
        }
    }

    public void translate(double d, double d2) {
        if (GraphConstants.isMoveable(this)) {
            List list;
            Rectangle2D rectangle2D = GraphConstants.getBounds(this);
            if (rectangle2D != null) {
                int n = GraphConstants.getMoveableAxis(this);
                if (n == 1) {
                    d2 = 0.0;
                } else if (n == 2) {
                    d = 0.0;
                }
                rectangle2D.setFrame(rectangle2D.getX() + d, rectangle2D.getY() + d2, rectangle2D.getWidth(), rectangle2D.getHeight());
            }
            if ((list = GraphConstants.getPoints(this)) != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Object e = list.get(i);
                    if (!(e instanceof Point2D)) continue;
                    Point2D point2D = (Point2D)e;
                    point2D.setLocation(point2D.getX() + d, point2D.getY() + d2);
                }
            }
        }
    }

    public void scale(double d, double d2, Point2D point2D) {
        Object object;
        Object object2;
        Rectangle2D rectangle2D = GraphConstants.getBounds(this);
        if (rectangle2D != null) {
            object2 = this.createPoint(rectangle2D.getX(), rectangle2D.getY());
            object = (Point2D)((Point2D)object2).clone();
            int n = GraphConstants.getSizeableAxis(this);
            if (n == 1) {
                d2 = 1.0;
            } else if (n == 2) {
                d = 1.0;
            }
            ((Point2D)object2).setLocation(point2D.getX() + (double)Math.round((((Point2D)object2).getX() - point2D.getX()) * d), point2D.getY() + (double)Math.round((((Point2D)object2).getY() - point2D.getY()) * d2));
            if (!((Point2D)object2).equals(object)) {
                this.translate(((Point2D)object2).getX() - ((Point2D)object).getX(), ((Point2D)object2).getY() - ((Point2D)object).getY());
            }
            double d3 = Math.max(1L, Math.round(rectangle2D.getWidth() * d));
            double d4 = Math.max(1L, Math.round(rectangle2D.getHeight() * d2));
            rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), d3, d4);
        }
        if ((object2 = GraphConstants.getPoints(this)) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (!(e instanceof Point2D)) continue;
                Point2D point2D2 = (Point2D)e;
                Point2D point2D3 = (Point2D)point2D2.clone();
                point2D3.setLocation(point2D.getX() + (double)Math.round((point2D3.getX() - point2D.getX()) * d), point2D.getY() + (double)Math.round((point2D3.getY() - point2D.getY()) * d2));
                point2D2.setLocation(point2D3);
            }
        }
    }

    public Map diff(Map map) {
        Hashtable hashtable = new Hashtable();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            Object v2 = this.get(k);
            if (v2 != null && v2.equals(v)) continue;
            hashtable.put(k, v);
        }
        return hashtable;
    }

    public Object clone() {
        return this.cloneEntries((AttributeMap)super.clone());
    }

    public AttributeMap cloneEntries(AttributeMap attributeMap) {
        Point point;
        List list;
        Rectangle2D rectangle2D = GraphConstants.getBounds(attributeMap);
        if (rectangle2D != null) {
            GraphConstants.setBounds(attributeMap, (Rectangle2D)rectangle2D.clone());
        }
        if ((list = GraphConstants.getPoints(attributeMap)) != null) {
            GraphConstants.setPoints(attributeMap, this.clonePoints(list));
        }
        if ((point = GraphConstants.getLabelPosition(attributeMap)) != null) {
            GraphConstants.setLabelPosition(attributeMap, new Point(point));
        }
        return attributeMap;
    }

    public static class SerializableRectangle2D
    extends Rectangle2D.Double
    implements Serializable {
        public SerializableRectangle2D() {
        }

        public SerializableRectangle2D(double d, double d2, double d3, double d4) {
            super(d, d2, d3, d4);
        }

        public void setX(double d) {
            this.setFrame(d, this.getY(), this.getWidth(), this.getHeight());
        }

        public void setY(double d) {
            this.setFrame(this.getX(), d, this.getWidth(), this.getHeight());
        }

        public void setWidth(double d) {
            this.setFrame(this.getX(), this.getY(), d, this.getHeight());
        }

        public void setHeight(double d) {
            this.setFrame(this.getX(), this.getY(), this.getWidth(), d);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeObject(new Double(this.getX()));
            objectOutputStream.writeObject(new Double(this.getY()));
            objectOutputStream.writeObject(new Double(this.getWidth()));
            objectOutputStream.writeObject(new Double(this.getHeight()));
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            Double d = (Double)objectInputStream.readObject();
            Double d2 = (Double)objectInputStream.readObject();
            Double d3 = (Double)objectInputStream.readObject();
            Double d4 = (Double)objectInputStream.readObject();
            this.setFrame(d, d2, d3, d4);
        }
    }

    public static class SerializablePoint2D
    extends Point2D.Double
    implements Serializable {
        public SerializablePoint2D() {
        }

        public SerializablePoint2D(double d, double d2) {
            super(d, d2);
        }

        public void setX(double d) {
            this.setLocation(d, this.getY());
        }

        public void setY(double d) {
            this.setLocation(this.getX(), d);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeObject(new Double(this.getX()));
            objectOutputStream.writeObject(new Double(this.getY()));
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            Double d = (Double)objectInputStream.readObject();
            Double d2 = (Double)objectInputStream.readObject();
            this.setLocation(d, d2);
        }
    }
}

