/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.Stack;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.ParentMap;
import org.jgraph.graph.PortView;

public class GraphLayoutCache
extends Observable
implements CellMapper,
Serializable {
    protected boolean autoSizeOnValueChange = false;
    protected boolean showsExistingConnections = true;
    protected boolean showsInsertedConnections = true;
    protected boolean hidesExistingConnections = true;
    protected boolean hidesDanglingConnections = false;
    protected boolean remembersCellViews = true;
    protected boolean selectsAllInsertedCells = true;
    protected boolean selectsLocalInsertedCells = true;
    protected GraphModel graphModel;
    protected transient Map mapping = new Hashtable();
    protected CellViewFactory factory = null;
    protected transient Set visibleSet = new HashSet();
    protected transient List roots = new ArrayList();
    protected transient PortView[] ports;
    protected transient List changed = new LinkedList();
    protected transient Map hiddenSet = new Hashtable();
    protected boolean partial = false;
    protected transient boolean inserted = false;
    protected boolean askLocalAttribute = true;
    protected Set localAttributes = new HashSet();

    public GraphLayoutCache(GraphModel graphModel, CellViewFactory cellViewFactory) {
        this(graphModel, cellViewFactory, false);
    }

    public GraphLayoutCache(GraphModel graphModel, CellViewFactory cellViewFactory, boolean bl) {
        this(graphModel, cellViewFactory, null, bl);
    }

    public GraphLayoutCache(GraphModel graphModel, CellViewFactory cellViewFactory, CellView[] cellViewArray, boolean bl) {
        this.factory = cellViewFactory;
        this.partial = bl;
        if (cellViewArray != null) {
            this.graphModel = graphModel;
            for (int i = 0; i < cellViewArray.length; ++i) {
                if (cellViewArray[i] == null) continue;
                this.putMapping(cellViewArray[i].getCell(), cellViewArray[i]);
                if (!bl) continue;
                this.visibleSet.add(cellViewArray[i].getCell());
            }
            this.insertViews(cellViewArray);
        } else {
            this.setModel(graphModel);
        }
    }

    protected void addChanged(CellView cellView) {
        if (!this.changed.contains(cellView)) {
            this.changed.add(cellView);
        }
    }

    public void addChanged(CellView[] cellViewArray) {
        if (cellViewArray != null) {
            this.setChanged();
            for (int i = 0; i < cellViewArray.length; ++i) {
                if (cellViewArray[i] == null) continue;
                this.addChanged(cellViewArray[i]);
            }
        }
    }

    public void setInserted() {
        this.setChanged();
        this.inserted = true;
    }

    public boolean getInserted() {
        return this.inserted;
    }

    public CellView[] getChanged() {
        CellView[] cellViewArray = new CellView[this.changed.size()];
        return this.changed.toArray(cellViewArray);
    }

    protected void resetChanged() {
        this.changed.clear();
        this.inserted = false;
    }

    public void notifyObservers(Object object) {
        super.notifyObservers(object);
        this.resetChanged();
    }

    public void setFactory(CellViewFactory cellViewFactory) {
        this.factory = cellViewFactory;
    }

    public CellViewFactory getFactory() {
        return this.factory;
    }

    public void setModel(GraphModel graphModel) {
        this.roots.clear();
        this.mapping.clear();
        this.hiddenSet.clear();
        this.visibleSet.clear();
        this.graphModel = graphModel;
        if (!this.isPartial()) {
            Object[] objectArray = DefaultGraphModel.getRoots(this.getModel());
            CellView[] cellViewArray = this.getMapping(objectArray, true);
            this.insertViews(cellViewArray);
            this.addChanged(cellViewArray);
        }
        this.updatePorts();
        this.notifyObservers(this);
    }

    public CellView[] getCellViews() {
        Collection collection = this.mapping.values();
        CellView[] cellViewArray = new CellView[collection.size()];
        collection.toArray(cellViewArray);
        return cellViewArray;
    }

    public synchronized void reload() {
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        Hashtable hashtable = new Hashtable(this.mapping);
        this.mapping.clear();
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            CellView cellView = (CellView)hashtable.get(k);
            CellView cellView2 = this.getMapping(k, true);
            cellView2.changeAttributes(cellView.getAttributes());
            if (!this.roots.contains(cellView)) continue;
            arrayList.add(cellView2);
        }
        this.hiddenSet.clear();
        this.roots = arrayList;
    }

    public GraphModel getModel() {
        return this.graphModel;
    }

    public CellView[] getRoots() {
        CellView[] cellViewArray = new CellView[this.roots.size()];
        this.roots.toArray(cellViewArray);
        return cellViewArray;
    }

    public CellView[] getRoots(Rectangle2D rectangle2D) {
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        CellView[] cellViewArray = this.getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (!cellViewArray[i].getBounds().intersects(rectangle2D)) continue;
            arrayList.add(cellViewArray[i]);
        }
        cellViewArray = new CellView[arrayList.size()];
        arrayList.toArray(cellViewArray);
        return cellViewArray;
    }

    public Object[] getVisibleCells(Object[] objectArray) {
        if (objectArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                if (!this.isVisible(objectArray[i])) continue;
                arrayList.add(objectArray[i]);
            }
            return arrayList.toArray();
        }
        return null;
    }

    public PortView[] getPorts() {
        return this.ports;
    }

    protected void updatePorts() {
        Object[] objectArray = DefaultGraphModel.getRoots(this.graphModel);
        List list = DefaultGraphModel.getDescendants(this.graphModel, objectArray);
        if (list != null) {
            ArrayList<CellView> arrayList = new ArrayList<CellView>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                CellView cellView;
                Object e = iterator.next();
                if (!this.graphModel.isPort(e) || (cellView = this.getMapping(e, false)) == null) continue;
                arrayList.add(cellView);
                cellView.refresh(this.getModel(), this, false);
            }
            this.ports = new PortView[arrayList.size()];
            arrayList.toArray(this.ports);
        }
    }

    public void refresh(CellView[] cellViewArray, boolean bl) {
        if (cellViewArray != null) {
            for (int i = 0; i < cellViewArray.length; ++i) {
                this.refresh(cellViewArray[i], bl);
            }
        }
    }

    public void refresh(CellView cellView, boolean bl) {
        if (cellView != null) {
            cellView.refresh(this.getModel(), this, bl);
            CellView[] cellViewArray = cellView.getChildViews();
            for (int i = 0; i < cellViewArray.length; ++i) {
                this.refresh(cellViewArray[i], bl);
            }
        }
    }

    public void update(CellView[] cellViewArray) {
        if (cellViewArray != null) {
            for (int i = 0; i < cellViewArray.length; ++i) {
                this.update(cellViewArray[i]);
            }
        }
    }

    public void update(CellView cellView) {
        if (cellView != null) {
            cellView.update();
            CellView[] cellViewArray = cellView.getChildViews();
            for (int i = 0; i < cellViewArray.length; ++i) {
                this.update(cellViewArray[i]);
            }
        }
    }

    public void graphChanged(GraphModelEvent.GraphModelChange graphModelChange) {
        Object object;
        Object object2;
        CellView[] cellViewArray = graphModelChange.getViews(this);
        if (cellViewArray != null) {
            for (int i = 0; i < cellViewArray.length; ++i) {
                if (cellViewArray[i] == null) continue;
                this.mapping.put(cellViewArray[i].getCell(), cellViewArray[i]);
            }
            this.setVisibleImpl(this.getCells(cellViewArray), true);
        }
        Object[] objectArray = graphModelChange.getChanged();
        CellView[] cellViewArray2 = this.getMapping(graphModelChange.getInserted(), true);
        cellViewArray = this.removeCells(graphModelChange.getRemoved());
        graphModelChange.putViews(this, cellViewArray);
        this.insertViews(cellViewArray2);
        if (this.isPartial()) {
            this.showCellsForChange(graphModelChange);
            this.hideCellsForChange(graphModelChange);
        }
        if (objectArray != null && objectArray.length > 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                object2 = this.getMapping(objectArray[i], false);
                if (object2 == null) continue;
                object2.refresh(this.getModel(), this, true);
                this.update((CellView)object2);
                CellView cellView = object2.getParentView();
                object = cellView != null ? cellView.getCell() : null;
                boolean bl = this.roots.contains(object2);
                if (object == null && !bl) {
                    this.roots.add(object2);
                    continue;
                }
                if (object == null || !bl) continue;
                this.roots.remove(object2);
            }
        }
        Object[] objectArray2 = DefaultGraphModel.getAll(this.graphModel);
        object2 = new ArrayList();
        for (int i = 0; i < objectArray2.length; ++i) {
            object = this.getMapping(objectArray2[i], false);
            if (object == null || !this.roots.contains(object)) continue;
            object2.add(object);
            object.refresh(this.getModel(), this, true);
        }
        this.roots = object2;
        this.refresh(this.getMapping(this.getContext(graphModelChange), false), false);
        this.updatePorts();
    }

    protected Object[] getContext(GraphModelEvent.GraphModelChange graphModelChange) {
        return graphModelChange.getContext();
    }

    protected void hideCellsForChange(GraphModelEvent.GraphModelChange graphModelChange) {
        Object[] objectArray = graphModelChange.getRemoved();
        HashSet<Object> hashSet = new HashSet<Object>();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                hashSet.add(objectArray[i]);
            }
        }
        if (this.hidesDanglingConnections || this.hidesExistingConnections) {
            Object[] objectArray2 = graphModelChange.getChanged();
            for (int i = 0; i < objectArray2.length; ++i) {
                CellView cellView = this.getMapping(objectArray2[i], false);
                if (!(cellView instanceof EdgeView)) continue;
                EdgeView edgeView = (EdgeView)cellView;
                Object object = edgeView.getSource() == null ? null : edgeView.getSource().getCell();
                Object object2 = edgeView.getTarget() == null ? null : edgeView.getTarget().getCell();
                Object object3 = this.graphModel.getSource(objectArray2[i]);
                Object object4 = this.graphModel.getTarget(objectArray2[i]);
                if ((!this.hidesDanglingConnections || !hashSet.contains(object) && !hashSet.contains(object2)) && (!this.hidesExistingConnections || (object3 == null || this.isVisible(object3)) && (object4 == null || this.isVisible(object4)))) continue;
                this.setVisibleImpl(new Object[]{objectArray2[i]}, false);
            }
        }
    }

    protected void showCellsForChange(GraphModelEvent.GraphModelChange graphModelChange) {
        Object[] objectArray;
        Object object;
        Object[] objectArray2 = graphModelChange.getInserted();
        if (objectArray2 != null && this.showsInsertedConnections) {
            for (int i = 0; i < objectArray2.length; ++i) {
                if (this.isVisible(objectArray2[i])) continue;
                Object object2 = this.graphModel.getSource(objectArray2[i]);
                object = this.graphModel.getTarget(objectArray2[i]);
                if (object2 == null && object == null || !this.isVisible(object2) || !this.isVisible(object)) continue;
                this.setVisibleImpl(new Object[]{objectArray2[i]}, true);
            }
        }
        if ((objectArray = graphModelChange.getChanged()) != null && this.showsExistingConnections) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.isVisible(objectArray[i])) continue;
                object = this.graphModel.getSource(objectArray[i]);
                Object object3 = this.graphModel.getTarget(objectArray[i]);
                if (object == null && object3 == null || !this.isVisible(object) || !this.isVisible(object3) || this.isVisible(objectArray[i])) continue;
                this.setVisibleImpl(new Object[]{objectArray[i]}, true);
            }
        }
    }

    public void insertViews(CellView[] cellViewArray) {
        if (cellViewArray != null) {
            this.refresh(cellViewArray, true);
            for (int i = 0; i < cellViewArray.length; ++i) {
                Object object;
                if (cellViewArray[i] == null || this.getMapping(cellViewArray[i].getCell(), false) == null) continue;
                CellView cellView = cellViewArray[i].getParentView();
                Object object2 = object = cellView != null ? cellView.getCell() : null;
                if (cellViewArray[i] instanceof PortView || this.roots.contains(cellViewArray[i]) || object != null) continue;
                this.roots.add(cellViewArray[i]);
            }
        }
    }

    public CellView[] removeCells(Object[] objectArray) {
        if (objectArray != null) {
            CellView[] cellViewArray = new CellView[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                cellViewArray[i] = this.removeMapping(objectArray[i]);
                if (cellViewArray[i] == null) continue;
                cellViewArray[i].removeFromParent();
                this.roots.remove(cellViewArray[i]);
                this.visibleSet.remove(cellViewArray[i].getCell());
            }
            return cellViewArray;
        }
        return null;
    }

    public Object[] getCells(CellView[] cellViewArray) {
        if (cellViewArray != null) {
            Object[] objectArray = new Object[cellViewArray.length];
            for (int i = 0; i < cellViewArray.length; ++i) {
                if (cellViewArray[i] == null) continue;
                objectArray[i] = cellViewArray[i].getCell();
            }
            return objectArray;
        }
        return null;
    }

    public CellView getMapping(Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        CellView cellView = (CellView)this.mapping.get(object);
        if (cellView == null && bl && this.isVisible(object)) {
            cellView = (CellView)this.hiddenSet.get(object);
            if (cellView != null) {
                this.putMapping(object, cellView);
                this.hiddenSet.remove(object);
            } else {
                cellView = this.factory.createView(this.graphModel, object);
                this.putMapping(object, cellView);
                cellView.refresh(this.getModel(), this, true);
                cellView.update();
            }
        }
        return cellView;
    }

    public CellView[] getMapping(Object[] objectArray) {
        return this.getMapping(objectArray, false);
    }

    public CellView[] getMapping(Object[] objectArray, boolean bl) {
        if (objectArray != null) {
            CellView[] cellViewArray = new CellView[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                cellViewArray[i] = this.getMapping(objectArray[i], bl);
            }
            return cellViewArray;
        }
        return null;
    }

    public void putMapping(Object object, CellView cellView) {
        if (object != null && cellView != null) {
            this.mapping.put(object, cellView);
        }
    }

    public CellView removeMapping(Object object) {
        if (object != null) {
            CellView cellView = (CellView)this.mapping.remove(object);
            return cellView;
        }
        return null;
    }

    public boolean isVisible(Object object) {
        return !this.isPartial() || this.visibleSet.contains(object) || object == null;
    }

    public Set getVisibleSet() {
        return new HashSet(this.visibleSet);
    }

    public void setVisibleSet(Set set) {
        this.visibleSet = set;
    }

    public void setVisible(Object object, boolean bl) {
        this.setVisible(new Object[]{object}, bl);
    }

    public void setVisible(Object[] objectArray, boolean bl) {
        if (bl) {
            this.setVisible(objectArray, null);
        } else {
            this.setVisible(null, objectArray);
        }
    }

    public void setVisible(Object[] objectArray, Object[] objectArray2) {
        objectArray = this.addVisibleDependencies(objectArray, true);
        objectArray2 = this.addVisibleDependencies(objectArray2, false);
        GraphViewEdit graphViewEdit = new GraphViewEdit(null, null, objectArray, objectArray2);
        graphViewEdit.end();
        this.graphModel.edit(null, null, null, new UndoableEdit[]{graphViewEdit});
    }

    public Object[] addVisibleDependencies(Object[] objectArray, boolean bl) {
        if (objectArray != null) {
            if (bl) {
                HashSet<Object> hashSet = new HashSet<Object>();
                for (int i = 0; i < objectArray.length; ++i) {
                    hashSet.add(objectArray[i]);
                    hashSet.addAll(this.getPorts(objectArray[i]));
                    hashSet.addAll(this.getParentPorts(this.graphModel.getSource(objectArray[i])));
                    hashSet.addAll(this.getParentPorts(this.graphModel.getTarget(objectArray[i])));
                }
                if (this.showsExistingConnections) {
                    Set set = DefaultGraphModel.getEdges(this.getModel(), objectArray);
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        Object object = this.graphModel.getSource(e);
                        Object object2 = this.graphModel.getTarget(e);
                        if (!this.isVisible(object) && !hashSet.contains(object) || !this.isVisible(object2) && !hashSet.contains(object2)) continue;
                        hashSet.add(e);
                    }
                }
                hashSet.removeAll(this.visibleSet);
                return hashSet.toArray();
            }
            if (this.hidesExistingConnections) {
                HashSet<Object> hashSet = new HashSet<Object>();
                for (int i = 0; i < objectArray.length; ++i) {
                    hashSet.addAll(this.getPorts(objectArray[i]));
                    hashSet.add(objectArray[i]);
                }
                hashSet.addAll(DefaultGraphModel.getEdges(this.graphModel, objectArray));
                hashSet.retainAll(this.visibleSet);
                return hashSet.toArray();
            }
        }
        return null;
    }

    public boolean setVisibleImpl(Object[] objectArray, boolean bl) {
        if (objectArray != null && this.isPartial()) {
            int n;
            boolean bl2 = false;
            CellView[] cellViewArray = new CellView[objectArray.length];
            if (!bl) {
                cellViewArray = this.removeCells(objectArray);
            }
            for (n = 0; n < objectArray.length; ++n) {
                if (objectArray[n] == null) continue;
                if (bl) {
                    this.visibleSet.add(objectArray[n]);
                    cellViewArray[n] = this.getMapping(objectArray[n], true);
                    continue;
                }
                if (cellViewArray[n] == null) continue;
                if (this.graphModel.contains(cellViewArray[n].getCell()) && this.remembersCellViews) {
                    this.hiddenSet.put(cellViewArray[n].getCell(), cellViewArray[n]);
                }
                bl2 = true;
            }
            if (bl) {
                for (n = 0; n < cellViewArray.length; ++n) {
                    if (cellViewArray[n] == null) continue;
                    CellView cellView = cellViewArray[n];
                    CellView[] cellViewArray2 = AbstractCellView.getDescendantViews(new CellView[]{cellView});
                    for (int i = 0; i < cellViewArray2.length; ++i) {
                        this.roots.remove(cellViewArray2[i]);
                    }
                    cellView.refresh(this.getModel(), this, false);
                    this.addChanged(cellView);
                    CellView cellView2 = cellView.getParentView();
                    if (cellView2 != null) {
                        cellView2.refresh(this.getModel(), this, true);
                    } else {
                        this.insertViews(new CellView[]{cellView});
                    }
                    bl2 = true;
                }
                this.setChanged();
                this.notifyObservers(this);
            }
            return bl2;
        }
        return false;
    }

    protected Collection getParentPorts(Object object) {
        Object object2 = this.graphModel.getParent(object);
        Collection collection = this.getPorts(object2);
        collection.add(object2);
        return collection;
    }

    protected Collection getPorts(Object object) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (int i = 0; i < this.graphModel.getChildCount(object); ++i) {
            Object object2 = this.graphModel.getChild(object, i);
            if (!this.graphModel.isPort(object2)) continue;
            linkedList.add(object2);
        }
        return linkedList;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public void valueForCellChanged(Object object, Object object2) {
        Map map = null;
        if (this.isAutoSizeOnValueChange()) {
            CellView cellView = this.getMapping(object, false);
            if (cellView != null) {
                AttributeMap attributeMap = cellView.getAllAttributes();
                Rectangle2D rectangle2D = GraphConstants.getBounds(attributeMap);
                Rectangle2D rectangle2D2 = attributeMap.createRect(rectangle2D.getX(), rectangle2D.getY(), 0.0, 0.0);
                map = GraphConstants.createAttributes(new Object[]{object}, new Object[]{"resize", "bounds"}, new Object[]{Boolean.TRUE, rectangle2D2});
            }
        } else {
            map = new Hashtable();
            map.put(object, new Hashtable());
        }
        this.augmentNestedMapForValueChange(map, object, object2);
        this.edit(map, null, null, null);
    }

    protected void augmentNestedMapForValueChange(Map map, Object object, Object object2) {
        Map map2 = (Map)map.get(object);
        if (map2 != null) {
            GraphConstants.setValue(map2, object2);
        }
    }

    public void insert(Object[] objectArray, Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        Object object;
        Object[] objectArray2 = null;
        if (this.isPartial()) {
            object = DefaultGraphModel.getDescendants(this.graphModel, objectArray);
            object.removeAll(this.visibleSet);
            if (!object.isEmpty()) {
                objectArray2 = object.toArray();
            }
        }
        if ((object = this.createLocalEdit(objectArray, map, objectArray2, null)) != null) {
            undoableEditArray = this.augment(undoableEditArray, (UndoableEdit)object);
        }
        this.graphModel.insert(objectArray, map, connectionSet, parentMap, undoableEditArray);
    }

    public Object[] insertClones(Object[] objectArray, Map map, Map map2, ConnectionSet connectionSet, ParentMap parentMap, double d, double d2) {
        if (objectArray != null) {
            if (connectionSet != null) {
                connectionSet = connectionSet.clone(map);
            }
            if (parentMap != null) {
                parentMap = parentMap.clone(map);
            }
            if (map2 != null) {
                map2 = GraphConstants.replaceKeys(map, map2);
                AttributeMap.translate(map2.values(), d, d2);
            }
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = map.get(objectArray[i]);
            }
            this.insert(objectArray2, map2, connectionSet, parentMap, null);
            return objectArray2;
        }
        return null;
    }

    public void insert(Object object) {
        this.insert(new Object[]{object});
    }

    public void insertEdge(Object object, Object object2, Object object3) {
        this.insert(new Object[]{object}, new Hashtable(), new ConnectionSet(object, object2, object3), new ParentMap());
    }

    public void insert(Object[] objectArray) {
        this.insert(objectArray, new Hashtable(), new ConnectionSet(), new ParentMap());
    }

    public void insert(Object[] objectArray, Map hashtable, ConnectionSet connectionSet, ParentMap parentMap) {
        if (objectArray != null) {
            if (hashtable == null) {
                hashtable = new Hashtable<Object, AttributeMap>();
            }
            if (connectionSet == null) {
                connectionSet = new ConnectionSet();
            }
            if (parentMap == null) {
                parentMap = new ParentMap();
            }
            for (int i = 0; i < objectArray.length; ++i) {
                Object object;
                int n = this.getModel().getChildCount(objectArray[i]);
                for (int j = 0; j < n; ++j) {
                    object = this.getModel().getChild(objectArray[i], j);
                    parentMap.addEntry(object, objectArray[i]);
                    AttributeMap attributeMap = this.getModel().getAttributes(object);
                    if (attributeMap == null) continue;
                    hashtable.put(object, attributeMap);
                }
                hashtable.put(objectArray[i], this.getModel().getAttributes(objectArray[i]));
                Object object2 = this.getModel().getSource(objectArray[i]);
                if (object2 != null) {
                    connectionSet.connect(objectArray[i], object2, true);
                }
                if ((object = this.getModel().getTarget(objectArray[i])) == null) continue;
                connectionSet.connect(objectArray[i], object, false);
            }
            objectArray = DefaultGraphModel.getDescendants(this.getModel(), objectArray).toArray();
            this.insert(objectArray, hashtable, connectionSet, parentMap, null);
        }
    }

    public void insertGroup(Object object, Object[] objectArray) {
        if (object != null && objectArray != null && objectArray.length > 0) {
            Hashtable<Object, AttributeMap> hashtable = new Hashtable<Object, AttributeMap>();
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length + 1);
            if (!this.getModel().contains(object)) {
                arrayList.add(object);
            }
            ParentMap parentMap = new ParentMap();
            for (int i = 0; i < objectArray.length; ++i) {
                parentMap.addEntry(objectArray[i], object);
                if (this.getModel().contains(objectArray[i])) continue;
                arrayList.add(objectArray[i]);
                AttributeMap attributeMap = this.getModel().getAttributes(objectArray[i]);
                if (attributeMap == null) continue;
                hashtable.put(objectArray[i], attributeMap);
            }
            if (arrayList.isEmpty()) {
                this.edit(hashtable, null, parentMap, null);
            } else {
                this.insert(arrayList.toArray(), hashtable, null, parentMap);
            }
        }
    }

    public void remove(Object[] objectArray) {
        this.graphModel.remove(objectArray);
    }

    public void remove(Object[] objectArray, boolean bl, boolean bl2) {
        if (objectArray != null && objectArray.length > 0) {
            if (bl2) {
                Object[] objectArray2 = DefaultGraphModel.getEdges(this.getModel(), objectArray).toArray();
                Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
                System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
                System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
                objectArray = objectArray3;
            }
            if (bl) {
                objectArray = DefaultGraphModel.getDescendants(this.getModel(), objectArray).toArray();
            }
            this.remove(objectArray);
        }
    }

    public void hideCells(Object[] objectArray, boolean bl) {
        if (objectArray != null && objectArray.length > 0) {
            if (bl) {
                objectArray = DefaultGraphModel.getDescendants(this.getModel(), objectArray).toArray();
            }
            this.setVisible(objectArray, false);
        }
    }

    public Object[] ungroup(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                boolean bl = false;
                for (int j = 0; j < this.getModel().getChildCount(objectArray[i]); ++j) {
                    Object object = this.getModel().getChild(objectArray[i], j);
                    if (this.getModel().isPort(object)) continue;
                    arrayList2.add(object);
                    bl = true;
                }
                if (!bl) continue;
                arrayList.add(objectArray[i]);
            }
            this.remove(arrayList.toArray());
            return arrayList2.toArray();
        }
        return null;
    }

    public void collapse(Object[] objectArray) {
        if (objectArray != null) {
            int n;
            List list = DefaultGraphModel.getDescendants(this.getModel(), objectArray);
            for (n = 0; n < objectArray.length; ++n) {
                list.remove(objectArray[n]);
            }
            for (n = 0; n < objectArray.length; ++n) {
                for (int i = 0; i < this.getModel().getChildCount(objectArray[n]); ++i) {
                    Object object = this.getModel().getChild(objectArray[n], i);
                    if (!this.getModel().isPort(object)) continue;
                    list.remove(object);
                }
            }
            this.setVisible(list.toArray(), false);
        }
    }

    public void expand(Object[] objectArray) {
        HashSet<Object> hashSet = new HashSet<Object>();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                for (int j = 0; j < this.getModel().getChildCount(objectArray[i]); ++j) {
                    hashSet.add(this.getModel().getChild(objectArray[i], j));
                }
            }
            this.setVisible(hashSet.toArray(), true);
        }
    }

    public void edit(Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        if (map != null || connectionSet != null || parentMap != null || undoableEditArray != null) {
            Serializable serializable;
            Object[] objectArray = null;
            if (this.isPartial()) {
                serializable = new HashSet();
                if (map != null) {
                    serializable.addAll(map.keySet());
                }
                if (connectionSet != null) {
                    serializable.addAll(connectionSet.getChangedEdges());
                }
                if (parentMap != null) {
                    serializable.addAll(parentMap.getChangedNodes());
                }
                serializable.removeAll(this.visibleSet);
                if (!serializable.isEmpty()) {
                    objectArray = serializable.toArray();
                }
                objectArray = this.addVisibleDependencies(objectArray, true);
            }
            if ((serializable = this.createLocalEdit(null, map, objectArray, null)) != null) {
                undoableEditArray = this.augment(undoableEditArray, (UndoableEdit)((Object)serializable));
            }
            this.graphModel.edit(map, connectionSet, parentMap, undoableEditArray);
        }
    }

    public void edit(Object[] objectArray, Map map) {
        if (map != null && objectArray != null && objectArray.length > 0) {
            Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
            for (int i = 0; i < objectArray.length; ++i) {
                hashtable.put(objectArray[i], map);
            }
            this.edit(hashtable, null, null, null);
        }
    }

    protected UndoableEdit[] augment(UndoableEdit[] undoableEditArray, UndoableEdit undoableEdit) {
        if (undoableEdit != null) {
            int n = undoableEditArray != null ? undoableEditArray.length + 1 : 1;
            UndoableEdit[] undoableEditArray2 = new UndoableEdit[n];
            if (undoableEditArray != null) {
                System.arraycopy(undoableEditArray, 0, undoableEditArray2, 0, n - 2);
            }
            undoableEditArray2[n - 1] = undoableEdit;
            return undoableEditArray2;
        }
        return undoableEditArray;
    }

    public void toBack(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            this.graphModel.toBack(objectArray);
        }
    }

    public void toFront(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            this.graphModel.toFront(objectArray);
        }
    }

    protected GraphViewEdit createLocalEdit(Object[] objectArray, Map map, Object[] objectArray2, Object[] objectArray3) {
        if (map != null && !map.isEmpty() && this.isAskLocalAttribute()) {
            Object object;
            Hashtable hashtable = new Hashtable();
            Hashtable hashtable2 = new Hashtable();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Hashtable hashtable3 = new Hashtable();
                object = iterator.next();
                Object k = object.getKey();
                Map map2 = (Map)object.getValue();
                CellView cellView = this.getMapping(k, false);
                if (cellView != null) {
                    map2 = cellView.getAllAttributes().diff(map2);
                }
                Iterator iterator2 = map2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry = iterator2.next();
                    Object k2 = entry.getKey();
                    Object v = entry.getValue();
                    boolean bl = this.isControlAttribute(k, k2, v);
                    if (!this.isLocalAttribute(k, k2, v) && !bl) continue;
                    hashtable3.put(k2, v);
                    if (bl) continue;
                    iterator2.remove();
                }
                if (!hashtable3.isEmpty()) {
                    hashtable2.put(k, hashtable3);
                }
                if (map2.isEmpty()) continue;
                hashtable.put(k, map2);
            }
            map.clear();
            map.putAll(hashtable);
            object = new GraphViewEdit(objectArray, new Hashtable(hashtable2), objectArray2, objectArray3);
            ((CompoundEdit)object).end();
            return object;
        }
        if (objectArray2 != null || objectArray3 != null) {
            GraphViewEdit graphViewEdit = new GraphViewEdit(objectArray, null, objectArray2, objectArray3);
            graphViewEdit.end();
            return graphViewEdit;
        }
        return null;
    }

    protected boolean isLocalAttribute(Object object, Object object2, Object object3) {
        return this.localAttributes.contains(object2);
    }

    protected boolean isControlAttribute(Object object, Object object2, Object object3) {
        return "removeAll".equals(object2) || "removeAttributes".equals(object2);
    }

    protected Map handleAttributes(Map map) {
        Hashtable<Object, AttributeMap> hashtable = new Hashtable<Object, AttributeMap>();
        CellView[] cellViewArray = new CellView[map.size()];
        Iterator iterator = map.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            CellView cellView;
            Map.Entry entry = iterator.next();
            cellViewArray[n] = cellView = this.getMapping(entry.getKey(), false);
            ++n;
            if (cellView == null) continue;
            this.addChanged(cellView);
            Map map2 = (Map)entry.getValue();
            AttributeMap attributeMap = cellView.getAttributes().applyMap(map2);
            cellView.refresh(this.getModel(), this, false);
            hashtable.put(cellView.getCell(), attributeMap);
        }
        this.update(cellViewArray);
        return hashtable;
    }

    public static void translateViews(CellView[] cellViewArray, double d, double d2) {
        cellViewArray = AbstractCellView.getDescendantViews(cellViewArray);
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (!cellViewArray[i].isLeaf()) continue;
            cellViewArray[i].getAllAttributes().translate(d, d2);
        }
    }

    public CellView[] getAllDescendants(CellView[] cellViewArray) {
        CellView[] cellViewArray2;
        Stack<CellView> stack = new Stack<CellView>();
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (cellViewArray[i] == null) continue;
            stack.add(cellViewArray[i]);
        }
        ArrayList<CellView[]> arrayList = new ArrayList<CellView[]>();
        while (!stack.isEmpty()) {
            int n;
            cellViewArray2 = (CellView[])stack.pop();
            CellView[] cellViewArray3 = cellViewArray2.getChildViews();
            for (n = 0; n < cellViewArray3.length; ++n) {
                stack.add(cellViewArray3[n]);
            }
            arrayList.add(cellViewArray2);
            for (n = 0; n < this.graphModel.getChildCount(cellViewArray2.getCell()); ++n) {
                CellView cellView;
                Object object = this.graphModel.getChild(cellViewArray2.getCell(), n);
                if (!this.graphModel.isPort(object) || (cellView = this.getMapping(object, false)) == null) continue;
                stack.add(cellView);
            }
        }
        cellViewArray2 = new CellView[arrayList.size()];
        arrayList.toArray(cellViewArray2);
        return cellViewArray2;
    }

    public Map getHiddenSet() {
        return this.hiddenSet;
    }

    public void setShowsExistingConnections(boolean bl) {
        this.showsExistingConnections = bl;
    }

    public void setShowsInsertedConnections(boolean bl) {
        this.showsInsertedConnections = bl;
    }

    public void setHidesExistingConnections(boolean bl) {
        this.hidesExistingConnections = bl;
    }

    public void setHidesDanglingConnections(boolean bl) {
        this.hidesDanglingConnections = bl;
    }

    public void setRemembersCellViews(boolean bl) {
        this.remembersCellViews = bl;
    }

    public void setHiddenSet(Map map) {
        this.hiddenSet = map;
    }

    public Set getLocalAttributes() {
        return this.localAttributes;
    }

    public void setLocalAttributes(Set set) {
        this.localAttributes = set;
    }

    public boolean isAskLocalAttribute() {
        return this.askLocalAttribute;
    }

    public void setAskLocalAttribute(boolean bl) {
        this.askLocalAttribute = bl;
    }

    public boolean isAutoSizeOnValueChange() {
        return this.autoSizeOnValueChange;
    }

    public void setAutoSizeOnValueChange(boolean bl) {
        this.autoSizeOnValueChange = bl;
    }

    public boolean isSelectsAllInsertedCells() {
        return this.selectsAllInsertedCells;
    }

    public void setSelectsAllInsertedCells(boolean bl) {
        this.selectsAllInsertedCells = bl;
    }

    public boolean isSelectsLocalInsertedCells() {
        return this.selectsLocalInsertedCells;
    }

    public void setSelectLocalInsertedCells(boolean bl) {
        this.selectsLocalInsertedCells = bl;
    }

    public class GraphViewEdit
    extends CompoundEdit
    implements GraphModelEvent.GraphViewChange,
    GraphModelEvent.ExecutableGraphChange {
        protected Object[] cells;
        protected Object[] previousCells = null;
        protected CellView[] context;
        protected CellView[] hidden;
        protected Map attributes;
        protected Object[] visible;
        protected Object[] invisible;

        public GraphViewEdit(Map map) {
            this(null, map, null, null);
            this.attributes = map;
        }

        public GraphViewEdit(Object[] objectArray, Map map, Object[] objectArray2, Object[] objectArray3) {
            this.attributes = map;
            this.cells = objectArray;
            this.visible = objectArray2;
            this.invisible = objectArray3;
        }

        public boolean isSignificant() {
            return true;
        }

        public Object getSource() {
            return GraphLayoutCache.this;
        }

        public Object[] getChanged() {
            if (this.attributes != null) {
                return this.attributes.keySet().toArray();
            }
            return null;
        }

        public Object[] getContext() {
            return this.context;
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        public void execute() {
            int n;
            HashSet<Object> hashSet = new HashSet<Object>();
            if (this.hidden != null) {
                for (n = 0; n < this.hidden.length; ++n) {
                    if (this.hidden[n] == null) continue;
                    GraphLayoutCache.this.mapping.put(this.hidden[n].getCell(), this.hidden[n]);
                }
            }
            if (!GraphLayoutCache.this.remembersCellViews) {
                this.hidden = GraphLayoutCache.this.getMapping(this.invisible);
            }
            n = GraphLayoutCache.this.setVisibleImpl(this.visible, true) | GraphLayoutCache.this.setVisibleImpl(this.invisible, false);
            if (this.visible != null) {
                for (int i = 0; i < this.visible.length; ++i) {
                    if (GraphLayoutCache.this.getModel().isEdge(this.visible[i])) continue;
                    hashSet.add(this.visible[i]);
                }
            }
            Object[] objectArray = this.visible;
            this.visible = this.invisible;
            this.invisible = objectArray;
            if (this.visible != null || this.invisible != null) {
                GraphLayoutCache.this.setChanged();
            }
            if (this.attributes != null) {
                hashSet.addAll(this.attributes.keySet());
                this.attributes = GraphLayoutCache.this.handleAttributes(this.attributes);
                GraphLayoutCache.this.setChanged();
            }
            if (n != 0) {
                GraphLayoutCache.this.updatePorts();
            }
            Set set = DefaultGraphModel.getEdges(GraphLayoutCache.this.getModel(), hashSet.toArray());
            this.context = GraphLayoutCache.this.getMapping(set.toArray());
            GraphLayoutCache.this.update(this.context);
            if (this.cells != null && GraphLayoutCache.this.isSelectsLocalInsertedCells()) {
                GraphLayoutCache.this.addChanged(GraphLayoutCache.this.getMapping(this.cells, false));
                GraphLayoutCache.this.setInserted();
            }
            objectArray = this.cells;
            this.cells = this.previousCells;
            this.previousCells = objectArray;
            GraphLayoutCache.this.notifyObservers(this);
        }
    }
}

