package edu.hust.go.annonation;

/**
 * <p>Title: </p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2005</p>
 *
 * <p>Company: </p>
 *
 * @author GQ Zhang
 * @version 1.0
 */

import java.io.*;
import java.util.*;

public class Annotation {
	public static final int db = 0;

	public static final int db_object_id = 1;

	public static final int db_object_symbol = 2;

	public static final int qualifier = 3;

	public static final int go_id = 4;

	public static final int db_reference = 5;

	public static final int evidence = 6;

	public static final int with_or_from = 7;

	public static final int aspect = 8;

	public static final int db_object_name = 9;

	public static final int db_object_synonym = 10;

	public static final int db_object_type = 11;

	public static final int taxon = 12;

	public static final int date = 13;

	public static final int assigned_by = 14;

	private String[] array;

	public Annotation(String[] _array) {
		array = _array;
	}

	public static void main(String[] args) {
		Hashtable<String,HashSet<String>> table = new Hashtable<String,HashSet<String>>();
		Annotation.loadDb(new File(
				"F:\\download\\gene_association.tigr_gene_index"), table);
	}

	public static void loadDb(File annotaFile, Hashtable<String,HashSet<String>> goIdTable) {
		String line;
		try {
			BufferedReader reader = new BufferedReader(new FileReader(
					annotaFile));
			while ((line = reader.readLine()) != null) {
				if (!line.startsWith("!")) {
					String[] array = line.split("\t");
					if (array.length == 15) {
						HashSet<String> set = goIdTable.get(array[go_id]) == null ? new HashSet<String>()
								: goIdTable.get(array[go_id]);
						set.add(line);
						goIdTable.put(array[go_id], set);
					} else {
						System.out.println(line);
					}
				}
			}
			reader.close();
			transForm(0, goIdTable);
		} catch (IOException e) {
			System.out.println(e);
		}
	}

	public static Hashtable<String,HashSet<String>> transForm(int index, Hashtable<String,HashSet<String>> goIdTable) {
		Hashtable<String,HashSet<String>> table = new Hashtable<String,HashSet<String>>();
		Object[] goids = goIdTable.keySet().toArray();
		for (int i = 0; i < goids.length; i++) {
			String[] records = (String[])goIdTable.get(goids[i]).toArray();
			for (int j = 0; j < records.length; j++) {
				String[] array = ((String) records[j]).split("\t");
				HashSet<String> set = table.get(array[index]) == null ? new HashSet<String>()
						: table.get(array[index]);
				set.add(records[j]);
				table.put(array[index], set);
			}
		}
		return table;
	}

	public static Hashtable<String,HashSet<String>> transForm(Hashtable<String,HashSet<String>> goIdTable) {
		Hashtable<String,HashSet<String>> table = new Hashtable<String,HashSet<String>>();
		Object[] goids = goIdTable.keySet().toArray();
		for (int i = 0; i < goids.length; i++) {
			String[] records =(String[]) goIdTable.get(goids[i]).toArray();
			for (int j = 0; j < records.length; j++) {
				String[] array = ((String) records[j]).split("\t");
				HashSet<String> set = table.get(array[1]) == null ? new HashSet<String>()
						: table.get(array[1]);
				set.add(records[j]);
				table.put(array[1], set);
			}
		}
		return table;
	}

	public String getAspect() {
		return array[aspect];
	}

	public String getAssigned_by() {
		return array[assigned_by];
	}

	public String getDate() {
		return array[date];
	}

	public String getDb() {
		return array[db];
	}

	public String getDb_object_id() {
		return array[db_object_id];
	}

	public String getDb_object_name() {
		return array[db_object_name];
	}

	public String getDb_object_symbol() {
		return array[db_object_symbol];
	}

	public String getDb_object_synonym() {
		return array[db_object_synonym];
	}

	public String getDb_object_type() {
		return array[db_object_type];
	}

	public String getDb_reference() {
		return array[db_reference];
	}

	public String getEvidence() {
		return array[evidence];
	}

	public String getGo_id() {
		return array[go_id];
	}

	public String getQualifier() {
		return array[qualifier];
	}

	public String getTaxon() {
		return array[taxon];
	}

	public String getWith_or_from() {
		return array[with_or_from];
	}
}
