package edu.hust.go.gui;

/**
 * <p>Title: GO4J</p>
 * <p>Description: Go api in Java</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: Life Science and Technology, HUST, China</p>
 * @author GQ Zhang
 * @version 1.0
 */
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.GraphConstants;
import edu.hust.go.term.GO_term;

public class GoEdge
    extends DefaultEdge {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private final String isa = "is_a";
    private final String partof = "part_of";

    private String relation = "";

    public GoEdge(GoCell sourceCell, GoCell targetCell) {
        super();
        Object targetObj = targetCell.getUserObject();
        Object sourceObj = sourceCell.getUserObject();
        if (targetObj instanceof GO_term && sourceObj instanceof GO_term) {
            GO_term term=(GO_term)targetObj;
            if (term.getIs_a() != null && term.getIs_a().contains( ( (GO_term) sourceObj).getId())) {
                    relation = isa;
           }
            else{
                relation = partof;
            }
        }
        sourceCell.addPort();
        setSource(sourceCell.getChildAt(0));
        targetCell.addPort();
        setTarget(targetCell.getChildAt(0));
        GraphConstants.setLineEnd(getAttributes(), GraphConstants.ARROW_CLASSIC);
    }

    public String getToolTipString() {
        return relation;
    }
}