#!/usr/bin/python

"""
__version__ = "$Revision: 1.6 $"
__date__ = "$Date: 2002/07/29 17:44:55 $"
"""

from PythonCardPrototype import model
import webbrowser
from Bio.Blast import NCBIStandalone

#variables mias.
blastexe="c:\\bioinfo-adv\\blast\\blastall.exe"
pathdb="c:\\bioinfo-adv\\blast\\data\\" # aca hay que agregar cada base en part.
tempdir="c:\\bioinfo-adv\\temp\\"

class WinBlast(model.Background):

    def on_menuFileExit_select(self, event):
        self.Close()
    def on_incrBtn_mouseClick(self, event):
        startValue = int(self.components.field1.text)
        endValue = startValue + 1
        self.components.field1.text = str(endValue)
    def on_decrBtn_mouseClick(self, event):
        startValue = int(self.components.field1.text)
        endValue = startValue - 1
        self.components.field1.text = str(endValue)
    def on_resetBtn_mouseClick(self, event):
        self.components.field1.text = "0"

    def on_SliderWordSize_mouseClick(self, event):
        pass
        #startValue = int(self.components.field1.text)
        #self.components.field1.text = str(endValue)
    def on_ComboBox1_selected(self, event):
        pass
    def on_Btnrunblast_mouseClick(self, event):
        if self.components.ComboDB.text=='nr':
            base='nr'
        elif self.components.ComboDB.text=='Arabidopsis Thaliana':
            base='atal.faa'
        elif self.components.ComboDB.text=='E.Coli':
            if (self.components.ComboBox1.text==('blastp'))|(self.components.ComboBox1.text==('blastx')):
                base='ecoli.aa'
            else:
                base='ecoli.nt'

        else:
            base='nr.aa'  # warning about this.
        print "BLAST: "
        print self.components.ComboBox1.text
        print pathdb+base
        print self.components.seqinput.text
        archentrada=open(tempdir+"input.txt",'w')
        archentrada.writelines(self.components.seqinput.text)
        archentrada.close()
        blast_out, error_info = NCBIStandalone.blastall(blastexe, self.components.ComboBox1.text, pathdb+base, tempdir+'input.txt', expectation=5, html='T')
        f=open(tempdir+"tempblast.htm", 'w')
        f.writelines(blast_out)
        f.close()
        webbrowser.open(tempdir+"tempblast.htm")
        # esto se tiene que habilitar solo con el texto lleno.
        

if __name__ == '__main__':
    app = model.PythonCardApp(WinBlast)
    app.MainLoop()
