\name{moex10stv1mmentrezgMAPCOUNTS} 

\alias{moex10stv1mmentrezgMAPCOUNTS}


\title{Number of mapped keys for the maps in package moex10stv1mmentrezg.db}

\description{
  moex10stv1mmentrezgMAPCOUNTS provides the "map count" (i.e. the
  count of mapped keys) for each map in package moex10stv1mmentrezg.db.
}

\details{  
  This "map count" information is precalculated and stored in the
  package annotation DB. This allows some quality control and is used by
  the \code{\link[AnnotationDbi:AnnDbPkg-checker]{checkMAPCOUNTS}}
  function defined in AnnotationDbi to compare and validate different
  methods (like \code{count.mappedkeys(x)} or
  \code{sum(!is.na(as.list(x)))}) for getting the "map count" of a given
  map.
}

\seealso{
  \code{\link[AnnotationDbi:Bimap-keys]{mappedkeys}},
  \code{\link[AnnotationDbi:Bimap-keys]{count.mappedkeys}},
  \code{\link[AnnotationDbi:AnnDbPkg-checker]{checkMAPCOUNTS}}
}

\examples{
  moex10stv1mmentrezgMAPCOUNTS
  mapnames <- names(moex10stv1mmentrezgMAPCOUNTS)
  moex10stv1mmentrezgMAPCOUNTS[mapnames[1]]
  x <- get(mapnames[1])
  sum(!is.na(as.list(x)))
  count.mappedkeys(x)   # much faster!

  ## Check the "map count" of all the maps in package moex10stv1mmentrezg.db
  checkMAPCOUNTS("moex10stv1mmentrezg.db")
}

\keyword{datasets}

