datacache <- new.env(hash=TRUE, parent=emptyenv())

hgfocushsentrezg <- function() showQCData("hgfocushsentrezg", datacache)
hgfocushsentrezg_dbconn <- function() dbconn(datacache)
hgfocushsentrezg_dbfile <- function() dbfile(datacache)
hgfocushsentrezg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hgfocushsentrezg_dbInfo <- function() dbInfo(datacache)

hgfocushsentrezgORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hgfocushsentrezg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hgfocushsentrezg", "chip hgfocushsentrezg", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hgfocushsentrezg_dbconn())
}

