datacache <- new.env(hash=TRUE, parent=emptyenv())

ragene10stv1rnrefseq <- function() showQCData("ragene10stv1rnrefseq", datacache)
ragene10stv1rnrefseq_dbconn <- function() dbconn(datacache)
ragene10stv1rnrefseq_dbfile <- function() dbfile(datacache)
ragene10stv1rnrefseq_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
ragene10stv1rnrefseq_dbInfo <- function() dbInfo(datacache)

ragene10stv1rnrefseqORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "ragene10stv1rnrefseq.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "ragene10stv1rnrefseq", "chip ragene10stv1rnrefseq", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(ragene10stv1rnrefseq_dbconn())
}

