datacache <- new.env(hash=TRUE, parent=emptyenv())

hgu133plus2hsentrezg <- function() showQCData("hgu133plus2hsentrezg", datacache)
hgu133plus2hsentrezg_dbconn <- function() dbconn(datacache)
hgu133plus2hsentrezg_dbfile <- function() dbfile(datacache)
hgu133plus2hsentrezg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hgu133plus2hsentrezg_dbInfo <- function() dbInfo(datacache)

hgu133plus2hsentrezgORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hgu133plus2hsentrezg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hgu133plus2hsentrezg", "chip hgu133plus2hsentrezg", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hgu133plus2hsentrezg_dbconn())
}

