datacache <- new.env(hash=TRUE, parent=emptyenv())

rae230arnentrezg <- function() showQCData("rae230arnentrezg", datacache)
rae230arnentrezg_dbconn <- function() dbconn(datacache)
rae230arnentrezg_dbfile <- function() dbfile(datacache)
rae230arnentrezg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
rae230arnentrezg_dbInfo <- function() dbInfo(datacache)

rae230arnentrezgORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "rae230arnentrezg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "rae230arnentrezg", "chip rae230arnentrezg", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(rae230arnentrezg_dbconn())
}

