datacache <- new.env(hash=TRUE, parent=emptyenv())

raex10stv1rnentrezg <- function() showQCData("raex10stv1rnentrezg", datacache)
raex10stv1rnentrezg_dbconn <- function() dbconn(datacache)
raex10stv1rnentrezg_dbfile <- function() dbfile(datacache)
raex10stv1rnentrezg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
raex10stv1rnentrezg_dbInfo <- function() dbInfo(datacache)

raex10stv1rnentrezgORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "raex10stv1rnentrezg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "raex10stv1rnentrezg", "chip raex10stv1rnentrezg", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(raex10stv1rnentrezg_dbconn())
}

