
\name{raex10stv1rnentrezg_dbconn}

\alias{raex10stv1rnentrezg_dbconn}
\alias{raex10stv1rnentrezg_dbfile}
\alias{raex10stv1rnentrezg_dbschema}
\alias{raex10stv1rnentrezg_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  raex10stv1rnentrezg_dbconn()
  raex10stv1rnentrezg_dbfile()
  raex10stv1rnentrezg_dbschema(file="", show.indices=FALSE)
  raex10stv1rnentrezg_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{raex10stv1rnentrezg_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{raex10stv1rnentrezg_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{raex10stv1rnentrezg_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{raex10stv1rnentrezg_dbschema} prints the schema definition of the
  package annotation DB.

  \code{raex10stv1rnentrezg_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{raex10stv1rnentrezg_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{raex10stv1rnentrezg_dbfile}: a character string with the path to the
  package annotation DB.

  \code{raex10stv1rnentrezg_dbschema}: none (invisible \code{NULL}).

  \code{raex10stv1rnentrezg_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "probes" table:
  dbGetQuery(raex10stv1rnentrezg_dbconn(), "SELECT COUNT(*) FROM probes")

  ## The connection object returned by raex10stv1rnentrezg_dbconn() was
  ## created with:
  dbConnect(SQLite(), dbname=raex10stv1rnentrezg_dbfile(), cache_size=64000,
  synchronous=0)

  raex10stv1rnentrezg_dbschema()

  raex10stv1rnentrezg_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

