datacache <- new.env(hash=TRUE, parent=emptyenv())

rae230brnentrezg <- function() showQCData("rae230brnentrezg", datacache)
rae230brnentrezg_dbconn <- function() dbconn(datacache)
rae230brnentrezg_dbfile <- function() dbfile(datacache)
rae230brnentrezg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
rae230brnentrezg_dbInfo <- function() dbInfo(datacache)

rae230brnentrezgORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "rae230brnentrezg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "rae230brnentrezg", "chip rae230brnentrezg", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(rae230brnentrezg_dbconn())
}

