datacache <- new.env(hash=TRUE, parent=emptyenv())

hgu133a2hsrefseq <- function() showQCData("hgu133a2hsrefseq", datacache)
hgu133a2hsrefseq_dbconn <- function() dbconn(datacache)
hgu133a2hsrefseq_dbfile <- function() dbfile(datacache)
hgu133a2hsrefseq_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hgu133a2hsrefseq_dbInfo <- function() dbInfo(datacache)

hgu133a2hsrefseqORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hgu133a2hsrefseq.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hgu133a2hsrefseq", "chip hgu133a2hsrefseq", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hgu133a2hsrefseq_dbconn())
}

