datacache <- new.env(hash=TRUE, parent=emptyenv())

moe430bmmentrezg <- function() showQCData("moe430bmmentrezg", datacache)
moe430bmmentrezg_dbconn <- function() dbconn(datacache)
moe430bmmentrezg_dbfile <- function() dbfile(datacache)
moe430bmmentrezg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
moe430bmmentrezg_dbInfo <- function() dbInfo(datacache)

moe430bmmentrezgORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "moe430bmmentrezg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "moe430bmmentrezg", "chip moe430bmmentrezg", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(moe430bmmentrezg_dbconn())
}

