
\name{moe430bmmentrezg_dbconn}

\alias{moe430bmmentrezg_dbconn}
\alias{moe430bmmentrezg_dbfile}
\alias{moe430bmmentrezg_dbschema}
\alias{moe430bmmentrezg_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  moe430bmmentrezg_dbconn()
  moe430bmmentrezg_dbfile()
  moe430bmmentrezg_dbschema(file="", show.indices=FALSE)
  moe430bmmentrezg_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{moe430bmmentrezg_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{moe430bmmentrezg_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{moe430bmmentrezg_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{moe430bmmentrezg_dbschema} prints the schema definition of the
  package annotation DB.

  \code{moe430bmmentrezg_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{moe430bmmentrezg_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{moe430bmmentrezg_dbfile}: a character string with the path to the
  package annotation DB.

  \code{moe430bmmentrezg_dbschema}: none (invisible \code{NULL}).

  \code{moe430bmmentrezg_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "probes" table:
  dbGetQuery(moe430bmmentrezg_dbconn(), "SELECT COUNT(*) FROM probes")

  ## The connection object returned by moe430bmmentrezg_dbconn() was
  ## created with:
  dbConnect(SQLite(), dbname=moe430bmmentrezg_dbfile(), cache_size=64000,
  synchronous=0)

  moe430bmmentrezg_dbschema()

  moe430bmmentrezg_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

