######## Detection of differentially expressed genes ##########

Limma2wayANOVA<-function()
{
Try({
	if(as.numeric(tclvalue(Stage))<10)
	{
		tkmessageBox(message="Please Finish the previous step!");
		tkfocus(tt);return();
	}
	tkconfigure(tt,cursor="watch")
# Select Case and Control 
	
	an=Input.Limma.2wayANOVA();
	if(as.numeric(an$ReturnValue)!=1) {tkconfigure(tt,cursor="arrow");tkfocus(tt);return();}

	contrast=unlist(an$contrast);
	lencontrast=length(contrast);

#Find the fold change
	factor.list=c(an$Selfac1,an$Selfac2);
	FL1=factor(data.info[,an$Selfac1]);
	FL2=factor(data.info[,an$Selfac2]);
	Comb=factor(paste(data.info[,an$Selfac1],data.info[,an$Selfac2],sep="."))
	out.fc=data.frame();
	for(i in 1: lencontrast)
	{
		tmp.factor=unlist(strsplit(contrast[i],":",fixed=T))
		tmp=unlist(strsplit(tmp.factor[2],"_VS_"))
		case=tmp[1];control=tmp[2];
		group.case=grepl(case,Comb)
		group.control=grepl(control,Comb)
		out.tmp=FindFC(exprs(data.eset)[,group.case],exprs(data.eset)[,group.control]);
		out.tmp=as.data.frame(out.tmp)
		colnames(out.tmp)=paste(contrast[[i]],colnames(out.tmp),sep="_")
		if(i==1) 
		{
			out.fc=out.tmp;
		}else{
			out.fc=cbind(out.fc,out.tmp);
		}
	}
	ID=rownames(out.fc);
	out.fc=cbind(ID,out.fc)
	colnames(out.fc)[1]=c("PROBEID")

#Find the P-Value From Limma
	label.model=""
	if(as.numeric(an$Selinter)) #there exists interaction!
	{
		label.model="Interaction";
	# Make the design Matri
		design=model.matrix(~0+Comb)
		colnames(design)=levels(Comb)
	# Make the contrast
		level=colnames(design);
		contrast.matrix=matrix(0,nrow=length(level),ncol=lencontrast)
		rownames(contrast.matrix)=level
		for(i in 1: lencontrast)
		{
		tmp.factor=unlist(strsplit(contrast[[i]],split=":"));
		tmp=unlist(strsplit(tmp.factor[2],"_VS_"))
		case=tmp[1];control=tmp[2];
		contrast.matrix[grepl(case,level),i]=1
		contrast.matrix[grepl(control,level),i]=-1
		}
		print(contrast.matrix)
	}else{
		label.model="NoInteraction";
		design=model.matrix(~FL1+FL2)
		colnames(design)[-1]=c(levels(FL1)[-1],levels(FL2)[-1]);
		level=colnames(design);
		contrast.matrix=matrix(0,nrow=length(level),ncol=lencontrast);
		rownames(contrast.matrix)=level;
		for(i in 1: lencontrast)
		{
			tmp.factor=unlist(strsplit(contrast[[i]],split=":"));
			tmp=unlist(strsplit(tmp.factor[2],"_VS_"))
			case=tmp[1];control=tmp[2];
			factor.id=which(factor.list %in% tmp.factor[1]);
			if(factor.id==1) 
			{
				local.level=levels(FL1);
			}else{
				local.level=levels(FL2);
			}
			if(case !=local.level[1] & control !=local.level[1])
			{
				contrast.matrix[grepl(case,level),i]=1;
				contrast.matrix[grepl(control,level),i]=-1	
			}else if(case==local.level[1])
			{
			 	contrast.matrix[grepl(control,level),i]=-1	
			}else if(control==local.level[1])
			{
				contrast.matrix[grepl(case,level),i]=1;
			} 
		}
		print(contrast.matrix)
	}
# Fit the model
	fit= lmFit(data.eset,design)
#Apply the contrast and Find the P-value
	fit2=contrasts.fit(fit,contrast.matrix)
	fit2=eBayes(fit2)
#Output the result
	Limma.out=data.frame();
	for(i in 1:lencontrast)
	{
		tmp.Limma.out=topTable(fit2,coef=i,adjust="fdr",number=Inf,sort.by="none")
		colnames(tmp.Limma.out)[1]="PROBEID";
		#tmp.Limma.out=tmp.Limma.out[order(tmp.Limma.out[,"PROBEID"]),]
		colnames(tmp.Limma.out)=paste(contrast[[i]],colnames(tmp.Limma.out),sep="_")
		if(i==1) 
		{	
			Limma.out=as.data.frame(tmp.Limma.out);
		}else{
			Limma.out=cbind(Limma.out,as.data.frame(tmp.Limma.out)[,-1]);
		}
	}
	colnames(Limma.out)[1]="PROBEID";
	tmp.out=merge(out.fc,Limma.out,by="PROBEID")

	tmp.name=paste("Limma.2wayAnova",label.model,an$Selfac1,an$Selfac2,sep="_")
	out<<-list(tmp.out,tmp.name,"limma",contrast)
	names(out)<<-c("result","name","type","contrast")
	UpStage(12,"Limma.2wayANOVA");
	tkconfigure(tt,cursor="arrow");
	tkfocus(tt);
});

}
