######## Detection of differentially expressed genes ##########

LimmaAdvance<-function()
{
Try({
	if(as.numeric(tclvalue(Stage))<10)
	{
		tkmessageBox(message="Please Finish the previous step!");
		tkfocus(tt);return();
	}
	tkconfigure(tt,cursor="watch")

# Select Case and Control 
	
	an=Input.Limma.Advance();
	if(as.numeric(an$ReturnValue)!=1) {tkconfigure(tt,cursor="arrow");tkfocus(tt);return();}

	contrast=an$Selconst;
	lencontrast=length(contrast);

#Find the fold change
	out.fc=data.frame();
	for(i in 1: lencontrast)
	{
		tmp.factor=unlist(strsplit(contrast[i],":",fixed=T))
		tmp=unlist(strsplit(tmp.factor[2],"_VS_"))
		case=tmp[1];control=tmp[2];
		if(grepl(".",tmp.factor[1],fixed=T)) 
		{
			#print("interaction!!");
			tmp.interaction=unlist(strsplit(tmp.factor[1],".", fixed =T))
			tmp.data.info=apply(data.info[,tmp.interaction],1,function(x) paste(x,collapse="."))
			group.case=grepl(case,tmp.data.info)
			group.control=grepl(control,tmp.data.info)
		}else{
			group.case=grepl(case,as.character(data.info[,tmp.factor[1]]),fixed=T)
			group.control=grepl(control,as.character(data.info[,tmp.factor[1]]),fixed=T)
		}
		out.tmp=FindFC(exprs(data.eset)[,group.case],exprs(data.eset)[,group.control]);
		out.tmp=as.data.frame(out.tmp)
		colnames(out.tmp)=paste(tmp.factor[2],colnames(out.tmp),sep="_")
		if(i==1) 
		{
			out.fc=out.tmp;
		}else{
			out.fc=cbind(out.fc,out.tmp);
		}
	}
	ID=rownames(out.fc);
	out.fc=cbind(ID,out.fc)
	colnames(out.fc)[1]=c("PROBEID");
########################################################################################################
	fac.add=list();
	tmp.fac=an$Selfac;
	fac.sel=array(T,length(tmp.fac));
	while(T)
	{
		tmp.fac.len=apply(as.matrix(tmp.fac),1,function(x) length(unlist(strsplit(x,split=".",fixed=T))));
		sel=which(tmp.fac.len==max(tmp.fac.len))[1];
		fac.add[length(fac.add)+1]=tmp.fac[sel]
		fac.sel[sel]=F;
		for(k in (1:length(tmp.fac))[fac.sel])
		{
			high.fac=tmp.fac[sel];
			tmp.k=unlist(strsplit(tmp.fac[k],split=".",fixed=T));
			if(sum(apply(as.matrix(tmp.k),1,function(x,y) grepl(x,y),y=high.fac))==length(tmp.k))
			{
				fac.sel[k]=F;
			}
		}
		if(sum(fac.sel)==0) break; 
		tmp.fac=tmp.fac[fac.sel];
		fac.sel=array(T,length(tmp.fac));
	}
	factor.sel=unlist(fac.add);
	for(i in 1:length(factor.sel))
	{
		tmp.fac=unlist(strsplit(factor.sel[i],".",fixed=T));
		tmp.comb=as.matrix(apply(as.matrix(data.info[,tmp.fac]),1,function(x) paste(x,collapse=".")));
		if(i==1)
		{
			comb=as.data.frame(factor(tmp.comb))
		}else{
			comb=cbind(comb,factor(tmp.comb))
		}
	}
	comb=cbind(comb,data.info[,an$Selblk]);
	colnames(comb)=c(factor.sel,an$Selblk);
	# Make the design Matrix
	design=model.matrix(~.,comb);
	factor.num=dim(as.matrix(comb))[2];
	tmp=NULL;
	for(i in 1:factor.num) tmp=c(tmp,levels(factor(comb[,i]))[-1])
	colnames(design)[-1]=tmp;
	level=colnames(design);
	contrast.matrix=matrix(0,nrow=length(level),ncol=lencontrast);
	rownames(contrast.matrix)=level;
	for(i in 1: lencontrast)
	{
		tmp.factor=unlist(strsplit(contrast[[i]],split=":"));
		tmp=unlist(strsplit(tmp.factor[2],"_VS_"))
		case=tmp[1];control=tmp[2];
		factor.id=grep(tmp.factor[1],factor.sel);
		local.level=levels(comb[,factor.sel[factor.id]]);
		if(case !=local.level[1] & control !=local.level[1])
		{
			contrast.matrix[grepl(case,level),i]=1;
			contrast.matrix[grepl(control,level),i]=-1	
		}else if(case==local.level[1])
		{
		 	contrast.matrix[grepl(control,level),i]=-1	
		}else if(control==local.level[1])
		{
			contrast.matrix[grepl(case,level),i]=1;
		} 
	}
	print(contrast.matrix)

# Fit the model
	fit= lmFit(data.eset,design)
#Apply the contrast and Find the P-value
	fit2=contrasts.fit(fit,contrast.matrix)
	fit2=eBayes(fit2)
#Output the result
	Limma.out=data.frame();
	for(i in 1:lencontrast)
	{
		tmp.Limma.out=topTable(fit2,coef=i,adjust="fdr",number=Inf,sort.by="none")
		colnames(tmp.Limma.out)[1]="PROBEID";
		#tmp.Limma.out=tmp.Limma.out[order(tmp.Limma.out[,"PROBEID"]),]
		tmp.constrast.name=unlist(strsplit(contrast[[i]],split=":",fix=T))[2];
		colnames(tmp.Limma.out)=paste(tmp.constrast.name,colnames(tmp.Limma.out),sep="_")
		if(i==1) 
		{	
			Limma.out=as.data.frame(tmp.Limma.out);
		}else{
			Limma.out=cbind(Limma.out,as.data.frame(tmp.Limma.out)[,-1]);
		}
	}
	colnames(Limma.out)[1]="PROBEID";
	tmp.out=merge(out.fc,Limma.out,by="PROBEID")
	contrast_clean=apply(as.matrix(contrast),1,function(x) unlist(strsplit(x,split=":",fix=T))[2])
	tmp.name=paste("Limma.AdvancedAnova_Factors",paste(an$Selfac,collapse="_"),"Block",paste(an$Selblk,collapse="_"),sep="_")
	out<<-list(tmp.out,tmp.name,"limma",contrast_clean)
	names(out)<<-c("result","name","type","contrast")
	UpStage(12,"Limma.AdvancedANOVA");
	tkconfigure(tt,cursor="arrow");
	tkfocus(tt);

});
}