require(tcltk)
if(path!="") setwd(path);

source("Source/functions.R")

Nothing<-function()
{
}
Quit <- function() {
   .Tcl("set ok_to_quit 1")
  tkdestroy(tt)
}
LoadRecentMenu<-function()
{
tkdelete(openRecentMenu,0,10);
recentFilesFileName=paste(tclvalue(Path),"/Source/RecentFiles.txt",sep="");
recentFiles=readLines(recentFilesFileName);
recentFiles=gsub("\\\\","/",recentFiles);
blanks=grep("^[ \t\n]*$",recentFiles);
if(length(blanks)>0) recentFiles=recentFiles[-blanks];
numRecentFiles=length(recentFiles);
if(numRecentFiles>0)
{
	for(i in 1:numRecentFiles)
	{
	tmp=tclVar(i);
	eval(parse(text=paste("assign(\"OpenProject_",i,"\",function() OpenProject(\"",recentFiles[i],"\"),.GlobalEnv)",sep="")));
	tkadd(openRecentMenu,"command",label=recentFiles[i],command=eval(parse(text=paste("OpenProject_",i,sep=""))));
	}
}else{
	tkadd(openRecentMenu,"command",label="Empty");
}
}
#########################################################################


tt <- tktoplevel(background="white")

tkwm.title(tt,"Microarray_R_US 1.0")

topMenu <- tkmenu(tt)
tkconfigure(tt,menu=topMenu)

# Menu
	#Project

fileMenu <- tkmenu(topMenu,tearoff=F) 
openRecentMenu=tkmenu(topMenu,tearoff=FALSE)

tkadd(fileMenu,"command",label="Create New Project",command=CreateNewProject)
tkadd(fileMenu,"command",label="Open Existing Project",command=function() OpenProject())
tkadd(fileMenu,"command",label="Save Project",command=SaveProject)
tkadd(fileMenu,"separator");
tkadd(fileMenu,"cascade",label="Open Recent Project",menu=openRecentMenu)

LoadRecentMenu();

tkadd(fileMenu,"separator");
tkadd(fileMenu,"command",label="Quit",command=Quit)

	# Data
DataMenu <- tkmenu(topMenu,tearoff=FALSE)
tkadd(DataMenu,"command",label="Optional: Download Public Data",command=AffyDownload)
tkadd(DataMenu,"command",label="Step1: Import Raw Data",command=ImportFile)
tkadd(DataMenu,"command",label="Step2: Import Design File",command=ReadInFile)
tkadd(DataMenu,"command",label="Optional: Inspect Design File",command=DesignTable)

	# Preprocessing
PreproMenu <- tkmenu(topMenu,tearoff=FALSE)
tkadd(PreproMenu,"command",label="Step1: Select Chip Description File",command=ChooseCDF)
tkadd(PreproMenu,"command",label="Step2: Select Preprocessing Methods",command=Prepro)


	# QC Analysis
QCMenu <- tkmenu(topMenu,tearoff=FALSE)
tkadd(QCMenu,"command",label="Quality Control",command=QC)
tkadd(QCMenu,"command",label="Hierarchical Clustering Analysis",command=DrawCluster)
tkadd(QCMenu,"command",label="Principle Components Analysis",command=DrawPca)

	# Power Analysis
PowerMenu <- tkmenu(topMenu,tearoff=FALSE)
tkadd(PowerMenu,"command",label="Fold Change",command=Power.foldchange)
tkadd(PowerMenu,"command",label="Power",command=Power.power)
tkadd(PowerMenu,"command",label="SampleSize",command=Power.samplesize)

	# Data Exploring
#ExploreMenu <- tkmenu(topMenu,tearoff=FALSE) 
#tkadd(ExploreMenu,"command",label="Hierarchical Clustering Analysis",command=DrawCluster)
#tkadd(ExploreMenu,"command",label="Principle Components Analysis",command=DrawPca)
 
	# Modeling Data
ModelMenu <- tkmenu(topMenu,tearoff=FALSE)
	LimmaMenu <- tkmenu(topMenu,tearoff=FALSE)
	SAMMenu <- tkmenu(topMenu,tearoff=FALSE)
	RankMenu <- tkmenu(topMenu,tearoff=FALSE)
	maSigProMenu <- tkmenu(topMenu,tearoff=FALSE)

tkadd(ModelMenu,"cascade",label=" Limma_Model ",menu=LimmaMenu)
tkadd(ModelMenu,"cascade",label=" SAM_Model ",menu=SAMMenu)
tkadd(ModelMenu,"cascade",label=" RankProduct_Model ",menu=RankMenu)
tkadd(ModelMenu,"cascade",label=" maSigPro ",menu=maSigProMenu)

tkadd(LimmaMenu,"command",label="Limma_1wayANOVA",command=Limma1wayANOVA)
tkadd(LimmaMenu,"command",label="Limma_2wayANOVA",command=Limma2wayANOVA)
tkadd(LimmaMenu,"command",label="Limma_1wayBlock",command=Limma1wayBlock)
tkadd(LimmaMenu,"command",label="Limma_Advance",command=LimmaAdvance)

tkadd(SAMMenu,"command",label="SAM_2unpaired",command=SAM.Unpaired)
tkadd(SAMMenu,"command",label="SAM_2paired",command=SAM.Paired)
#tkadd(SAMMenu,"command",label="SAM_SeveralGroups",command=SAM.Mult)

tkadd(RankMenu,"command",label="RandProd_OneOrigin",command=RankProd2Group)
tkadd(RankMenu,"command",label="RankProd_MultOrigin",command=RankProd.MultOrigin)

tkadd(maSigProMenu,"command",label="maSigPro_TimeCourse",command=TimemaSigPro)


	# Output
OutputMenu <- tkmenu(topMenu,tearoff=FALSE)
tkadd(OutputMenu,"command",label="Generate Gene List",command=GeneList)
tkadd(OutputMenu,"command",label="Inspect DEG list",command=Display.OutputTable)
tkadd(OutputMenu,"command",label="Draw Heatmap Based on DEG list",command=DrawHeatmap)
tkadd(OutputMenu,"command",label="Draw Venn Diagram",command=DrawVenn)
tkadd(OutputMenu,"command",label="Gene List Output Utility",command=GeneUtility)

HelpMenu <- tkmenu(topMenu,tearoff=FALSE)
tkadd(HelpMenu,"command",label="Visit Software website",command=Helpwebsite)
tkadd(HelpMenu,"command",label="User Guide",command=Helpuserguide)
tkadd(HelpMenu,"command",label="Bug Report or Feedback",command=HelpReportBug)
tkadd(HelpMenu,"command",label="Contact US",command=Helpcontactus)

tkadd(HelpMenu,"separator");
tkadd(HelpMenu,"command",label="About MicroArray R US!",command=HelpAbout)

# Add in all the sub menus

tkadd(topMenu,"cascade",label="Project",menu=fileMenu)
tkadd(topMenu,"cascade",label="Data Import",menu=DataMenu)
tkadd(topMenu,"cascade",label="Data Preprocessing",menu=PreproMenu)
#tkadd(topMenu,"cascade",label="Data Exploring",menu=ExploreMenu)
tkadd(topMenu,"cascade",label="Quality Control",menu=QCMenu)
tkadd(topMenu,"cascade",label="Differential Expression Analysis",menu=ModelMenu)
tkadd(topMenu,"cascade",label="Power Analysis",menu=PowerMenu)
tkadd(topMenu,"cascade",label="Results Output",menu=OutputMenu)
tkadd(topMenu,"cascade",label="Help",menu=HelpMenu)




#For Title
fontHeading <- tkfont.create(family="times",size=24,weight="bold")
fontHeading2 <- tkfont.create(family="times",size=12,weight="bold")
fontHeading3 <- tkfont.create(family="times",size=10,weight="bold")
fontHeading4 <- tkfont.create(family="times",size=10,weight="bold")

Label.title=tklabel(tt,text=" Welcome to Microarray R US",background="white",font=fontHeading);

FrameMain <- tkframe(tt,background="white")

frame1 <- tkframe(FrameMain,relief="flat",background="white",borderwidth=2)
frame2 <- tkframe(FrameMain,relief="flat",background="white",borderwidth=2)
frame3 <- tkframe(FrameMain,relief="flat",background="white",borderwidth=2)
frame4 <- tkframe(FrameMain,relief="flat",background="white",borderwidth=2)

#For Frame1
fix.taskdone=tklabel(frame1,text="Task Completed: ",anchor="e",background="white",font=fontHeading2,width=23)
fix.tasktodo=tklabel(frame1,text="Task to be Completed: ",anchor="e",background="white",font=fontHeading2,width=23)


#For Frame2

Label1=tklabel(frame2,font=fontHeading2,foreground="red",background="white",anchor="w",width=80)
Label2=tklabel(frame2,font=fontHeading2,foreground="blue",background="white",anchor="w",width=80)


InsertBlacnkLine<-function(mess=" ")
{
tkgrid(tklabel(tt,text=mess,background="white",width=100));
}

#For Frame3

tmp=GetProperty()[1:13,];

for(i in 1:length(tmp[,1]))
{
 nam=paste("l",i, sep="")
 assign(nam, tklabel(frame3,text=paste(rownames(tmp)[i]," : ",sep=""),anchor="e",font=fontHeading3,background="white",width=30))
 nam=paste("v",i, sep="")
 assign(nam, tklabel(frame4,textvariable=get(tmp[i,2]),anchor="w",font=fontHeading3,background="white"))
}

# Layout

InsertBlacnkLine(" ");
tkgrid(Label.title);
InsertBlacnkLine(" ");

tkgrid(fix.taskdone,sticky="n");

tkgrid(fix.tasktodo,sticky="s");

tkconfigure(Label1,textvariable=label.taskdone)
tkgrid.configure(Label1,sticky="w")

tkconfigure(Label2,textvariable=label.tasktodo)
tkgrid.configure(Label2,sticky="w")

for(i in 1:length(tmp[,1]))
{
	nam=paste("l",i,sep="");
	tkgrid.configure(get(nam),sticky="e")
	nam=paste("v",i,sep="");
	tkconfigure(get(nam),textvariable=get(tmp[i,2]))
	tkgrid.configure(get(nam),sticky="w")
}

#Frame

tkgrid(tklabel(FrameMain,text="Work Flow Log:          ",font=fontHeading2,foreground="blue",background="white",anchor="w"));

tkgrid(frame3,frame4,sticky="w");

tkgrid(tklabel(FrameMain,text=" ",background="white",width=10));
tkgrid(tklabel(FrameMain,text=" ",background="white",width=10));
tkgrid(tklabel(FrameMain,text="Task Status:          ",font=fontHeading2,foreground="blue",background="white",anchor="w"));

tkgrid(frame1,frame2,sticky="w");

tkgrid(FrameMain);
UpStage(1);
tkfocus(tt);

tkbind(tt, "<Destroy>",Quit);

.Tcl("set ok_to_quit 1");
#.Tcl("vwait ok_to_quit");