Display.OutputTable<-function()
{
Try({
	if(as.numeric(tclvalue(Stage))<13)
	{
		tkmessageBox(message="Please Finish the previous step!");
		tkfocus(tt);return();
	}
	tkconfigure(tt,cursor="watch");
OnOK<- function()
{	
	tkgrab.release(tt.sub)
	tkdestroy(tt.sub)
	tkfocus(tt)
}
OnCancel <- function()
{	
	tkgrab.release(tt.sub)
	tkdestroy(tt.sub)
	tkfocus(tt)
}
#require lib
	tclRequire("Tktable")
#Initial panel
	tt.sub= tktoplevel(tt);
	tkwm.deiconify(tt.sub)
	tkgrab.set(tt.sub)
	tkfocus(tt.sub)
	tkwm.title(tt.sub,"Display of Output Table")
	tmp.len=110;
	
	tclarray=tclArray()
	tmp=as.data.frame(ga.output$result.filtered);
	n=dim(tmp)
	for(j in 1:n[2]-1) tclarray[[0,j]]=colnames(tmp)[j+1]

	for (i in (1:n[1]))
  		for (j in (0:(n[2]-1)))
     			if(is.numeric(tmp[i,j+1])) 
			{
				tclarray[[i,j]]=as.character(round(tmp[i,j+1],3));
			}else{
				tmp.string=as.character(gsub(" ","_",as.character(tmp[i,j+1])));
				if(nchar(tmp.string)>=25) tmp.string=paste(substring(tmp.string,1,20),"...",sep="")
				tclarray[[i,j]]=tmp.string
			}
				
	nrow=n[1]+1
	ncol=n[2]
#font
	font.tmp<- tkfont.create(family="times",size=12,weight="bold",slant="italic");
	font.tmp2=tkfont.create(family="times",size=10)
#Frame
	FrameMain1 <- tkframe(tt.sub)
	FrameMain2 <- tkframe(tt.sub)
#subFrame
	frame0 <- tkframe(FrameMain1,relief="groove",borderwidth=2,background="white")
	frame1 <- tkframe(FrameMain2,relief="flat",borderwidth=2)
	frame2 <- tkframe(FrameMain2,relief="flat",borderwidth=2)
#subsubFrame	

#Add object
##############################################
#top
	label0=tklabel(frame0,text=" ",width=tmp.len,background="white")
	label0.1=tklabel(frame0,text="Please inspect the design table:",background="white")
	label0.2=tklabel(frame0,text="Edit and reload the design file if necessary.",background="white")
	label0.3=tklabel(frame0,text="If the table is corrected, please proceed to next step.",background="white")
# top layout
	tkgrid(label0);
	tkgrid(label0.1,sticky="wn");tkgrid(label0.2,sticky="wn");tkgrid(label0.3,sticky="wn");
##################################################################
#middle
#
	 table1 <- tkwidget(frame1,"table",rows=nrow,cols=max(10,ncol),titlerows=1,titlecols=0,
                     height=20,colwidth=30,
                     xscrollcommand=function(...) tkset(xscr,...),yscrollcommand=function(...) tkset(yscr,...))
  	xscr <-tkscrollbar(frame1,orient="horizontal", command=function(...)tkxview(table1,...))
  	yscr <- tkscrollbar(frame1,command=function(...)tkyview(table1,...))

#middle layout

	tkgrid(table1,yscr)
  	tkconfigure(table1,multiline="1",font=font.tmp2)
  	tkgrid.configure(yscr,sticky="nsw")
  	tkgrid(xscr,sticky="new")
  	tkconfigure(table1,variable=tclarray,background="white",selectmode="extended",resizeborders="col")
	tkconfigure(table1,selectmode="extended",rowseparator="\"\n\"",colseparator="\"\t\"")
	tkconfigure(table1,multiline="1",state="disabled")

##################################################################
#bottom
	Save.but <-tkbutton(frame2,text="OK",command=OnOK,width=10)
	Cancel.but <-tkbutton(frame2,text="Cancel",command=OnCancel,width=10)
#bottom layout
 	tkgrid(Save.but,Cancel.but,sticky="es");
##################################################################
#layout frame
	tkgrid(frame0);
	tkgrid(frame1);
	tkgrid(frame2);
	tkgrid(FrameMain1);tkgrid(FrameMain2);
	tkfocus(tt.sub)
	tkwait.window(tt.sub)
})
	tkconfigure(tt,cursor="arrow");
}