DrawVenn<-function()
{
Try({
	if(as.numeric(tclvalue(Stage))<2)
	{
		tkmessageBox(message="Please select the project first!");
		return();
	}
	tkconfigure(tt,cursor="watch");
	an=Input.DrawVenn();
	if(as.numeric(an$ReturnValue)!=1) {tkconfigure(tt,cursor="arrow");tkfocus(tt);return();}
	if(as.numeric(an$sel1)!=1 & as.numeric(an$sel2)!=1 ) {tkconfigure(tt,cursor="arrow");tkfocus(tt);return();}

	numInput=sum(c(an$file3!="",an$file2!="",an$file1!=""))
	if(an$file1!="") data1=read.delim(an$file1,sep='\t',header=T);
	if(an$file2!="") data2=read.delim(an$file2,sep='\t',header=T);
	if(an$file3!="") data3=read.delim(an$file3,sep='\t',header=T);
	if(numInput==1) return();

	if(as.numeric(an$sel1)==1)
	{
		if(numInput==3)
		{
			list1=as.character(data1[,1]);
			list2=as.character(data2[,1]);
			list3=as.character(data3[,1]);
			total=union(list1,union(list2,list3));
			Input1=total %in% list1;
			Input2=total %in% list2;
			Input3=total %in% list3;
			g=cbind(Input1,Input2,Input3)
			c <- vennCounts(g);
		
			tmp.list=unlist(strsplit(an$file1,"/"));
			file1=tmp.list[length(tmp.list)];
			tmp.list=unlist(strsplit(an$file2,"/"));
			file2=tmp.list[length(tmp.list)];
			tmp.list=unlist(strsplit(an$file3,"/"));
			file3=tmp.list[length(tmp.list)];

			input.string=paste("Input1: ",file1," \n",
					"Input2: ",file2," \n",
					"Input3: ",file3," \n",sep="");
####################################################
			path.output=paste(tclvalue(Path.project),"/Output/Venn",sep="");
			output_path2=path.output;
			if(!file.exists(output_path2)) dir.create(output_path2,recursive=T)
			out_names=an$fname1;
			filename=paste(path.output,"/",out_names,".pdf",sep="");
			pdf(file=filename);
	
			vennDiagram(c,circle.col=c("red","green","blue"),cex=1,sub="Venn diagram for gene list comparision");
			mtext(input.string,side=3,line=0,adj=0,col="blue",cex=0.8,font=4);
			dev.off();
		}else{
			list1=as.character(data1[,1]);
			list2=as.character(data2[,1]);
	
			total=union(list1, list2)
			same=intersect(list1, list2)

			Input1=total %in% list1;
			Input2=total %in% list2;
			g=cbind(Input1,Input2);
			c <- vennCounts(g);
			tmp.list=unlist(strsplit(an$file1,"/"));
			file1=tmp.list[length(tmp.list)];
			tmp.list=unlist(strsplit(an$file2,"/"));
			file2=tmp.list[length(tmp.list)];

			input.string=paste("Input1: ",file1," \n",
					"Input2: ",file2," \n",sep="");
####################################################
			path.output=paste(tclvalue(Path.project),"/Output/Venn",sep="");
			output_path2=path.output;
			if(!file.exists(output_path2)) dir.create(output_path2,recursive=T)
			out_names=an$fname1;
			filename=paste(path.output,"/",out_names,".pdf",sep="");
			pdf(file=filename);

			vennDiagram(c,circle.col=c("red","green"),cex=1,sub="Venn diagram for gene list comparision");
			mtext(input.string,side=3,line=0,adj=0,col="blue",cex=0.8,font=4);

			dev.off();
######################################################
		}
		tkmessageBox(message=paste("The file has been save as: \n",filename,sep=""),icon="info",type="ok")
	}
	if(as.numeric(an$sel2)==1)
	{
		data1=merge(data1,data2,by="PROBEID");
		if(numInput==3) {data1=merge(data1,data3,by="PROBEID");}	

		path.output=tclvalue(Path.output);
		out_names=an$fname2;
		filename=paste(path.output,"/",out_names,".DEG.txt",sep="");
		write.table(data1,file=filename,sep="\t",quote=F,row.names=F);
		tkmessageBox(message=paste("The file has been save as: \n",filename,sep=""),icon="info",type="ok")
	}
	tkconfigure(tt,cursor="arrow");
	tkfocus(tt);
});
}
Input.DrawVenn<-function()
{
OnOK <- function()
  {
	tclvalue(ReturnValue)=1;
	tkgrab.release(tt.sub)
	tkdestroy(tt.sub)
	tkfocus(tt)
  }

OnCancel <- function()
{	
	tkgrab.release(tt.sub)
	tkdestroy(tt.sub)
	tkfocus(tt)
}
 ChooseF1 <- function()
  {
    	file.tmp=tclvalue(tkgetOpenFile(title="Please Choose your read in output file!",filetypes="{{DEG Files} {.DEG.txt}}",initialdir="output/"))
	if(file.tmp!="") tclvalue(file1)=file.tmp;
  }
  ChooseF2 <- function()
  {
    	file.tmp=tclvalue(tkgetOpenFile(title="Please Choose your read in output file!",filetypes="{{DEG Files} {.DEG.txt}}",initialdir="output/"))
	if(file.tmp!="") tclvalue(file2)=file.tmp;
  }
  ChooseF3 <- function()
  {
    	file.tmp=tclvalue(tkgetOpenFile(title="Please Choose your read in output file!",filetypes="{{DEG Files} {.DEG.txt}}",initialdir="output/"))
	if(file.tmp!="") tclvalue(file3)=file.tmp;
  }

  Sel1 <- function()
  {
	if(as.numeric(tclvalue(cbValue1))==1)
	{
		tkconfigure(entry1,state="normal");
	}else{
		tkconfigure(entry1,state="disabled");
	}
  }
  Sel2 <- function()
  {
	if(as.numeric(tclvalue(cbValue2))==1)
	{
		tkconfigure(entry2,state="normal");
	}else{
		tkconfigure(entry2,state="disabled");
	}
  }

#Initial panel
	tt.sub= tktoplevel(tt);
	tkwm.deiconify(tt.sub)
	tkgrab.set(tt.sub)
	tkfocus(tt.sub)
	tkwm.title(tt.sub,"Draw venn diagram for gene list comparision")
	tmp.len=100;
	ReturnValue=tclVar(0);
#font
	font.tmp<- tkfont.create(family="times",size=12,weight="bold",slant="italic");
#Frame
	FrameMain1 <- tkframe(tt.sub)
	FrameMain2 <- tkframe(tt.sub)
#subFrame
	frame0 <- tkframe(FrameMain1,relief="groove",borderwidth=2,background="white")
	frame1 <- tkframe(FrameMain2,relief="flat",borderwidth=2)
	frame2 <- tkframe(FrameMain2,relief="flat",borderwidth=2)
#subsubFrame	
	frame1a <- tkframe(frame1,relief="flat",borderwidth=2)
	frame1b <- tkframe(frame1,relief="flat",borderwidth=2)
		frame1b.1 <- tkframe(frame1b,relief="flat",borderwidth=2)
		frame1b.2 <- tkframe(frame1b,relief="flat",borderwidth=2)
	frame1c <- tkframe(frame1,relief="flat",borderwidth=2)
		frame1c.1 <- tkframe(frame1c,relief="flat",borderwidth=2)
		frame1c.2 <- tkframe(frame1c,relief="flat",borderwidth=2)
#Add object
##############################################
#top
	label0=tklabel(frame0,text=" ",width=tmp.len,background="white")
	label0.1=tklabel(frame0,text="Please enter the gene lists for comparision",background="white")
# top layout
	tkgrid(label0);tkgrid(label0.1,sticky="wn");
##################################################################
#middle

	file1=tclVar();
	file2=tclVar();
	file3=tclVar();
	entry.Name1 <-tkentry(frame1a,width="50",textvariable=file1)
	entry.Name2 <-tkentry(frame1a,width="50",textvariable=file2)
	entry.Name3 <-tkentry(frame1a,width="50",textvariable=file3)

	F1.but <-tkbutton(frame1a,text="select a gene list",command=ChooseF1);
	F2.but <-tkbutton(frame1a,text="select a gene list",command=ChooseF2);
	F3.but <-tkbutton(frame1a,text="select a gene list",command=ChooseF3);

	InputValue1 <- tclVar("VennDiagram");
	cbValue1 <- tclVar("1");
	cb1=tkcheckbutton(frame1b.1,variable=cbValue1,command=Sel1);
	word1=tklabel(frame1b.1,text="Select to generate Venn Diagram and enter the filename");
	entry1= tkentry(frame1b.2,width="50",textvariable=InputValue1)

	InputValue2 <- tclVar("Intersection");
	cbValue2 <- tclVar("1");
	cb2=tkcheckbutton(frame1c.1,variable=cbValue2,command=Sel2);
	word2=tklabel(frame1c.1,text="Select to generate Intersection of gene lists and enter the filename");
	entry2= tkentry(frame1c.2,width="50",textvariable=InputValue2)

#middle layout

	tkgrid(tklabel(frame1,text="Please Choose the output files to compare:                           "))
	tkgrid(entry.Name1,F1.but);
	tkgrid(entry.Name2,F2.but);
	tkgrid(entry.Name3,F3.but);

	tkgrid(cb1,word1);tkgrid(entry1);
	tkgrid(cb2,word2);tkgrid(entry2);

	tkgrid(frame1b.1,sticky="w");tkgrid(frame1b.2,sticky="w");
	tkgrid(frame1c.1,sticky="w");tkgrid(frame1c.2,sticky="w");
	tkgrid(frame1a);tkgrid(frame1b,sticky="w");tkgrid(frame1c,sticky="w");
##################################################################
#bottom
	OK.but <-tkbutton(frame2,text="OK",command=OnOK,width=10)
	Cancel.but <-tkbutton(frame2,text="Cancel",command=OnCancel,width=10)
#bottom layout
 	tkgrid(OK.but,Cancel.but,sticky="es");
##################################################################
#layout frame
	tkgrid(frame0);
	tkgrid(frame1);
	tkgrid(frame2);
	tkgrid(FrameMain1);tkgrid(FrameMain2);
	tkfocus(tt.sub)
	tkwait.window(tt.sub)
	return(list(ReturnValue=tclvalue(ReturnValue),file1=tclvalue(file1),
			file2=tclvalue(file2),file3=tclvalue(file3),
			sel1=tclvalue(cbValue1),sel2=tclvalue(cbValue2),
			fname1=tclvalue(InputValue1),fname2=tclvalue(InputValue2)))
}