#Common Ones:
#1 
	ToSYMBOLOnly<-function(mess,data.filtered,file.filtered)
	{
		namelist=c("SYMBOL");
		data.out=as.data.frame(data.filtered[,namelist]);
		colnames(data.out)=namelist;
		filename=gsub("DEG.txt",mess,file.filtered)
		write.table(data.out,file=filename,sep="\t",quote=F,row.names=F,col.names=F)
	}
#2   
	To5Param<-function(mess,data.filtered,file.filtered)
	{	
		namelist=c("PROBEID","SYMBOL","FC","P","FDRP","Q");
		namelist_in=namelist[namelist %in% colnames(data.filtered)]
		data.out=data.filtered[,namelist_in];
		filename=gsub("DEG.txt",mess,file.filtered)
		write.table(data.out,file=filename,sep="\t",quote=F,row.names=F)
	}
#####################################################

	ToOntoPE<-function(data.filtered,file.filtered)
	{
		namelist=c("SYMBOL","FC");
		data.out=as.data.frame(data.filtered[,namelist]);
		filename=gsub("DEG.txt","Onto-PE.txt",file.filtered)
		write.table(data.out,file=filename,sep="\t",quote=F,row.names=F,col.names=F)
	}

	ToTFacts<-function(data.filtered,file.filtered)
	{
		namelist=c("SYMBOL");

		data.out1=as.data.frame(data.filtered[data.filtered[,"FC"]>0,namelist]);
		colnames(data.out1)="SYMBOL";
		filename1=gsub("DEG.txt","UP_TFactS.txt",file.filtered)
		write.table(data.out1,file=filename1,sep="\t",quote=F,row.names=F,col.names=F)

		data.out2=as.data.frame(data.filtered[data.filtered[,"FC"]<0,namelist]);
		colnames(data.out2)="SYMBOL";
		filename2=gsub("DEG.txt","DOWN_TFactS.txt",file.filtered)
		write.table(data.out2,file=filename2,sep="\t",quote=F,row.names=F,col.names=F)
	}

	ToGeneTrail<-function(data.all,data.filtered,file.all,file.filtered)
	{
		namelist1=c("SYMBOL","P");
		data.out1=as.data.frame(data.filtered[,namelist1]);
		colnames(data.out1)="SYMBOL";
		filename1=gsub("DEG.txt","GeneTrail-SEA.txt",file.filtered)
		write.table(data.out1,file=filename1,sep="\t",quote=F,row.names=F,,col.names=F)

		namelist2=c("SYMBOL","P");
		data.out2=as.data.frame(data.all[,namelist2]);
		data.out2=as.data.frame(data.out2[order(data.out2[,"P"]),"SYMBOL"]);
		colnames(data.out2)="SYMBOL";
		filename2=gsub("DEGcomplete.txt","GeneTrail-GSEA.txt",file.all)
		write.table(data.out2,file=filename2,sep="\t",quote=F,row.names=F,,col.names=F)
	}


	ToWebGestalt<-function(data.filtered,file.filtered)
	{
		namelist=c("SYMBOL","FC");
		data.out=as.data.frame(data.filtered[,namelist]);
		filename=gsub("DEG.txt","WebGestalt.txt",file.filtered)
		write.table(data.out,file=filename,sep="\t",quote=F,row.names=F,,col.names=F)
	}

	ToGorilla<-function(data.all,file.all)
	{
		namelist2=c("SYMBOL","P");
		data.out2=as.data.frame(data.all[,namelist2]);
		data.out2=as.data.frame(data.out2[order(data.out2[,"P"]),"SYMBOL"]);
		colnames(data.out2)="SYMBOL";
		filename2=gsub("DEGcomplete.txt","GOrilla.txt",file.all)
		write.table(data.out2,file=filename2,sep="\t",quote=F,row.names=F,,col.names=F)
	}
	
	ToDAVID<-function(data.filtered,file.filtered)
	{
		namelist=c("PROBEID");
		data.out=as.data.frame(data.filtered[,namelist]);
		colnames(data.out)=namelist;
		filename=gsub("DEG.txt","DAVID.txt",file.filtered)
		write.table(data.out,file=filename,sep="\t",quote=F,row.names=F,,col.names=F)
	}

	ToGoMiner<-function(data.filtered,file.filtered)
	{
		namelist=c("SYMBOL","FC");
		data.out=as.data.frame(data.filtered[,namelist]);
		tmp.fc=data.out[,"FC"];
		data.out[tmp.fc>0,"FC"]="+";
		data.out[tmp.fc<0,"FC"]="-";
		colnames(data.out)=c("SYMBOL","SIGN");
		filename=gsub("DEG.txt","GoMiner.txt",file.filtered)
		write.table(data.out,file=filename,sep="\t",quote=F,row.names=F,,col.names=F)
	}

	ToGenMAPP<-function(data.all,file.all)
	{
		namelist=c("ENSEMBL","Case.Mean","Control.Mean","FC","P","FDRP");
		data.out=as.data.frame(data.all[,namelist]);
		colnames(data.out)=namelist;
		filename=gsub("DEGcomplete.txt","GenMAPP.txt",file.all)
		write.table(data.out,file=filename,sep="\t",quote=F,row.names=F)
	}

	ToGenePattern<-function(data.all,data.prep,file.all,mess1="GenePattern.gct",mess2="GenePattern.cls")
	{
		Try({
		data.prep[,-1]=2^data.prep[,-1];
		filename1=gsub("DEGcomplete.txt",mess1,file.all);

		text=paste("#1.2","\n",dim(data.all)[1],"\t",dim(data.prep)[2]-1,sep="");
		data.out=merge(data.all,data.prep,by="PROBEID")
		tmp.names=colnames(data.prep)[-1];
		data.out=data.out[,c("PROBEID","SYMBOL",tmp.names)]
		f.gct=file(filename1,"w");
		writeLines(text,con=f.gct,sep="\n");
		write.table(data.out,file=f.gct,sep="\t",quote=F,row.names=F);
		close(f.gct);
		});
		Try({
		filename2=gsub("DEGcomplete.txt",mess2,file.all);

		an=Input.GenePattern();
		data.info=read.csv(an$pheno,header=T);
		fl=levels(as.factor(data.info[,an$class]));
		#print(an$class);
		text2=paste(dim(data.prep)[2]-1," ",length(fl)," ","1",sep="")
		text2=paste(text2,"\n","#"," ",paste(fl,collapse=" "),sep="")
		tmp=as.character(data.info[,an$class])
		text2=paste(text2,"\n",paste(tmp,collapse=" "),sep="");
		writeLines(text2,con=filename2,sep="\n");
		});
	}
	ToGSEA<-function(data.all,data.prep,file.all)
	{
		print("test1");
		ToGenePattern(data.all,data.prep,file.all,mess1="GSEA.gct",mess2="GSEA.cls");
		namelist2=c("SYMBOL","P");
		data.out2=as.data.frame(data.all[,namelist2]);
		data.out2=as.data.frame(data.out2[order(data.out2[,"P"]),"SYMBOL"]);
		colnames(data.out2)="SYMBOL";
		filename2=gsub("DEGcomplete.txt","GSEA.rnk",file.all)
		write.table(data.out2,file=filename2,sep="\t",quote=F,row.names=F)
	}
	
	ToEXALT<-function(data.all,data.prep,file.all)
	{
		data.prep[,-1]=2^data.prep[,-1];
		filename1=gsub("DEGcomplete.txt","EXALT.txt",file.all);
		data.out=merge(data.all,data.prep,by="PROBEID")
		tmp.names=colnames(data.prep)[-1];
		data.out=data.out[,c("PROBEID","SYMBOL",tmp.names)]
		write.table(data.out,file=filename1,sep="\t",quote=F,row.names=F);
	}
	ToMAGIA<-function(data.all,data.prep,file.all)
	{
		data.prep[,-1]=2^data.prep[,-1];
		filename1=gsub("DEGcomplete.txt","MAGIA.txt",file.all);
		data.out=merge(data.all,data.prep,by="PROBEID")
		tmp.names=colnames(data.prep)[-1];
		out.name=c("ENTREZID",tmp.names);
		if(sum(out.name %in% colnames(data.out))<length(out.name))
		{
			missed.name=paste(out.name[!out.name %in% colnames(data.out)],collapse =" , ");
			tkmessageBox(message=paste("ToMAGIA Failed!\nRequired column ",missed.name," is missing!",sep=""));
			return();
		}
		data.out=data.out[,c("ENTREZID",tmp.names)]
		write.table(data.out,file=filename1,sep="\t",quote=F,row.names=F);
	}
	
	ToMMIA<-function(data.all,data.prep,file.all)
	{
		data.prep[,-1]=2^data.prep[,-1];
		filename1=gsub("DEGcomplete.txt","MMIA.txt",file.all);
		data.out=merge(data.all,data.prep,by="PROBEID")
		tmp.names=colnames(data.prep)[-1];
		out.name=c("SYMBOL",tmp.names);
		if(sum(out.name %in% colnames(data.out))<length(out.name))
		{
			missed.name=paste(out.name[!out.name %in% colnames(data.out)],collapse =" , ");
			tkmessageBox(message=paste("ToMMIA Failed!\nRequired column ",missed.name," is missing!",sep=""));
			return();
		}
		data.out=data.out[,c("SYMBOL",tmp.names)]
		write.table(data.out,file=filename1,sep="\t",quote=F,row.names=F);
	}

	ToConnectivityMap<-function(data.filtered,file.filtered)
	{
		file.path=paste(tclvalue(Path),"/Source/HGU_133A_Total_List.txt",sep="");
		datamap=read.table(file.path,header=T)

		filtered.gene=data.filtered[,c("SYMBOL","FC")];
		if(dim(filtered.gene)[1]>1000) 
		{
			filtered.gene=filtered.gene[1:1000,];
			tkmessageBox(title="For Input file of ConnectivityMap",message="The DEG list exceeds 1000. \nOnly top 1000 genes will be used for the requirement of Connectivity Map.",icon="info",type="ok")
		}
		up.gene=filtered.gene[filtered.gene[,"FC"]>0,"SYMBOL"];
		down.gene=filtered.gene[filtered.gene[,"FC"]<0,"SYMBOL"];

		data.out.up=datamap[datamap[,2] %in% unique(up.gene),"PROBE_ID"];
		data.out.down=datamap[datamap[,2] %in% unique(down.gene),"PROBE_ID"];
		filename.up=gsub("DEG.txt","UP_CMAP.grp",file.filtered);
		filename.down=gsub("DEG.txt","DOWN_CMAP.grp",file.filtered);
		write.table(data.out.up,file=filename.up,sep="\t",quote=F,row.names=F,col.names=F);
		write.table(data.out.down,file=filename.down,sep="\t",quote=F,row.names=F,col.names=F);
	}
