Input.SAM.GeneList<-function()
{
OnOK <- function()
{	
	contrsize=as.numeric(tclvalue(tksize(tl1.2)));
	if(contrsize!=0)
	{
		for(i in 1:contrsize) Sel.colname.list[[i]]<<-tclvalue(tkget(tl1.2,i-1));
		tclvalue(ReturnValue)=1;
	}
	tkgrab.release(tt.sub)
	tkdestroy(tt.sub)
	tkfocus(tt)
}
OnCheck <- function()
{	
	colnames=Sel.colname.list;
	SelFc=tclvalue(cbValue1);
	SelP=tclvalue(cbValue2);
	SelAdjP=tclvalue(cbValue3);
	Fc=tclvalue(InputValue1);
	P=tclvalue(InputValue2);
	AdjP=tclvalue(InputValue3);
	colFc=tclvalue(SelValue1);
	colP=tclvalue(SelValue2);
	colAdjP=tclvalue(SelValue3);

	tmp.out=out$result;
	select.num=array(T,dim(tmp.out)[1])
	if(SelFc=="1" & colFc!="UnSelected") {select.tmp=abs(as.numeric(as.character(tmp.out[,colFc])))>=as.numeric(Fc); select.num =select.num & select.tmp;}
	if(SelP=="1" & colP!="UnSelected") {select.tmp=as.numeric(as.character(tmp.out[,colP])) < as.numeric(P); select.num =select.num & select.tmp;}
	if(SelAdjP=="1" & colAdjP!="UnSelected") 
	{
		de=findDelta(out$outset,fdr=AdjP)[2];
		output.fdr=rownames(summary(out$outset,de)@mat.sig);
		select.tmp=tmp.out[,"PROBEID"] %in% output.fdr;
		select.num =select.num & select.tmp;
	}
	tclvalue(SelValueNum)=sum(select.num);
}
OnCancel <- function()
{	
	tkgrab.release(tt.sub)
	tkdestroy(tt.sub)
	tkfocus(tt)
}
Selcol<-function()
{
	tmps=colname.list[as.numeric(tkcurselection(tl1.1))+1]
	if(length(tmps)==0) return();
	tmplist=list();
	tmpindex=as.numeric(tclvalue(tksize(tl1.2)));
	if(tmpindex>=1)
	{
		for(i in 1:tmpindex) tmplist[[i]]=tclvalue(tkget(tl1.2,i-1)); 
	}
	for(i in 1:length(tmps))
	{
		tmp=tmps[i];
		if(length(tmp)!=0) 
		{
 	   	if(!tmp%in%tmplist) tkinsert(tl1.2,"end",tmp)
		}
	}
}
Selall<-function()
{
	while(as.numeric(tksize(tl1.2))!=0) tkdelete(tl1.2,as.integer(0));
	for (i in (1:length(colname.list)))
	{
 	   tkinsert(tl1.2,"end",colname.list[i])
	}
}
Delcol<-function()
{
    Index <- as.integer(tkcurselection(tl1.2))
    if(length(Index)==0) return();
	for(i in 1:length(Index))
	{
		tmp=Index[i];
    		tkdelete(tl1.2,tmp)
		Index=Index-1;
	}
}
Delall<-function()
{
	while(as.numeric(tksize(tl1.2))!=0) tkdelete(tl1.2,as.integer(0));
}
SelectContrast<-function()
{
	tmplist=list();
	tmpindex=as.numeric(tclvalue(tksize(tl1.2)));
	if(tmpindex>=1)
	{
		for(i in 1:tmpindex) tmplist[i]=tclvalue(tkget(tl1.2,i-1)); 
		tmp.sel=as.numeric(tkcurselection(tl1.2))+1;
		if(length(tmp.sel)!=1) return();
		tmps=tmplist[[tmp.sel]];
		tmp.con=array(F,length(out$contrast));
		for(i in 1:length(out$contrast)) tmp.con[i]=grepl(out$contrast[i],tmps)
		contrast=out$contrast[[which(tmp.con)]];

		tclvalue(SelValue1)=paste(contrast,"_FC",sep="");
		tclvalue(SelValue2)=paste(contrast,"_P.Value",sep="");
		tclvalue(SelValue3)=paste(contrast,"_adj.P.Val",sep="");
	}
}
Sel1 <- function()
{
	if(as.numeric(tclvalue(cbValue1))==1)
	{
		tkconfigure(entry.fc,state="normal");
	}else{
		tkconfigure(entry.fc,state="disabled");
	}
}
Sel2 <- function()
{
	if(as.numeric(tclvalue(cbValue2))==1)
	{
		tkconfigure(entry.p,state="normal");
	}else{
		tkconfigure(entry.p,state="disabled");
	}
}
Sel3 <- function()
{
	if(as.numeric(tclvalue(cbValue3))==1)
	{
		tkconfigure(entry.adjp,state="normal");
	}else{
		tkconfigure(entry.adjp,state="disabled");
	}
}
#Initial panel
	tt.sub= tktoplevel(tt);
	tkwm.deiconify(tt.sub)
	tkgrab.set(tt.sub)
	tkfocus(tt.sub)
	tkwm.title(tt.sub,"Generate gene list")
	tmp.len=120;
	ReturnValue=tclVar(0);
	Sel.colname.list=list();
#font
	font.tmp<- tkfont.create(family="times",size=12,weight="bold");
	font.tmp2<- tkfont.create(family="times",size=10,weight="bold");
#Frame
	FrameMain1 <- tkframe(tt.sub)
	FrameMain2 <- tkframe(tt.sub)
#subFrame
	frame0 <- tkframe(FrameMain1,relief="groove",borderwidth=2,background="white")
	frame1 <- tkframe(FrameMain2,relief="flat",borderwidth=20)
	frame2 <- tkframe(FrameMain2,relief="flat",borderwidth=10)
#subsubFrame
	frame1o <- tkframe(frame1,relief="flat",borderwidth=5)
	frame2o <- tkframe(frame1,relief="flat",borderwidth=5)	
	frame1a <- tkframe(frame1,relief="flat",borderwidth=5)
		frame1a.1 <- tkframe(frame1a,relief="flat",borderwidth=2)
		frame1a.2 <- tkframe(frame1a,relief="flat",borderwidth=2)
		frame1a.3 <- tkframe(frame1a,relief="flat",borderwidth=2)
			frame1a.31 <- tkframe(frame1a.3,relief="flat",borderwidth=2)
			frame1a.32 <- tkframe(frame1a.3,relief="flat",borderwidth=2)
	frame1b <- tkframe(frame1,relief="flat",borderwidth=5)

	frame1c0 <- tkframe(frame1,relief="flat",borderwidth=5)
	frame1c <- tkframe(frame1,relief="flat",borderwidth=5)
		frame1c.0 <- tkframe(frame1c,relief="flat",borderwidth=2)
		frame1c.1 <- tkframe(frame1c,relief="flat",borderwidth=2)
		frame1c.2 <- tkframe(frame1c,relief="flat",borderwidth=2)
		frame1c.3 <- tkframe(frame1c,relief="flat",borderwidth=2)
	frame1d <- tkframe(frame1,relief="flat",borderwidth=0)
	frame2.2 <- tkframe(frame2,relief="flat",borderwidth=2)
#Add object
##############################################
#top
	label0=tklabel(frame0,text=" ",width=tmp.len,background="white")
	label0.1=tklabel(frame0,text="Please Input for the gene list generator:",background="white")
# top layout
	tkgrid(label0);tkgrid(label0.1,sticky="wn");
##################################################################
#middle

	colname.list=colnames(out$result)[-1];

	label1.1=tklabel(frame1o,text="Step1: Select the columns to output",font=font.tmp)
	label1.10=tklabel(frame2o,text="ID and Annotation will be automatically added.")
	tl1.1=tklistbox(frame1a.1,height=6,width=40,selectmode="extended",background="white",yscrollcommand=function(...)tkset(scr1.1,...))
	for (i in (1:length(colname.list)))
	{
 	   tkinsert(tl1.1,"end",colname.list[i])
	}
	tkselection.set(tl1.1,0)  # Default choice is 2nd.Indexing starts at zero.
	scr1.1<- tkscrollbar(frame1a.1, repeatinterval=5,command=function(...)tkyview(tl1.1,...))

	but1.1 <-tkbutton(frame1a.2,text="Select One ->",command=Selcol,width=15)
	but1.2 <-tkbutton(frame1a.2,text="Select All ->",command=Selall,width=15)

	tl1.2=tklistbox(frame1a.31,height=6,width=40,selectmode="extended",background="white",yscrollcommand=function(...)tkset(scr1.2,...))
	scr1.2<- tkscrollbar(frame1a.31, repeatinterval=5,command=function(...)tkyview(tl1.2,...))
	but1.3 <-tkbutton(frame1a.32,text="Delete",command=Delcol,width=15)
	but1.4 <-tkbutton(frame1a.32,text="Delete All",command=Delall,width=15)


	SelValue1=tclVar("FC");
	SelValue2=tclVar("P.Value");
	SelValue3=tclVar("Q.Value");

	InputValue1 <- tclVar()
	InputValue2 <- tclVar()
	InputValue3 <- tclVar()

	label3.1=tklabel(frame1c0,text="Step2: Enter the parameters for the cutoff.",font=font.tmp)

	word.tip=  tklabel(frame1c.0,text=" For the tips on setting the parameters, please refert o the manual. ")

	entry.fc <-tkentry(frame1c.1,width="10",textvariable=InputValue1)
	entry.p <-tkentry(frame1c.2,width="10",textvariable=InputValue2)
	entry.adjp <-tkentry(frame1c.3,width="10",textvariable=InputValue3)
	word.fc=  tklabel(frame1c.1,text="Please enter your fold change cutoff:       ")
	word.p=   tklabel(frame1c.2,text="Please enter your raw p value cutoff:        ")
	word.adjp=tklabel(frame1c.3,text="Please enter your FDR adjp value cutoff:  ")
	cb1 <- tkcheckbutton(frame1c.1,command=Sel1)
	cb2 <- tkcheckbutton(frame1c.2,command=Sel2)
	cb3 <- tkcheckbutton(frame1c.3,command=Sel3)
	cbValue1 <- tclVar("0")
	cbValue2 <- tclVar("0")
	cbValue3 <- tclVar("0")
	tkconfigure(cb1,variable=cbValue1) #fold change
	tkconfigure(cb2,variable=cbValue2) #raw P value
	tkconfigure(cb3,variable=cbValue3) #Q value
	word.fc2=  tklabel(frame1c.1,text=" On the column: ")
	word.p2=   tklabel(frame1c.2,text=" On the column: ")
	word.adjp2=tklabel(frame1c.3,text=" On the column: ")
	word.fc3=  tklabel(frame1c.1,textvariable=SelValue1,background="white")
	word.p3=   tklabel(frame1c.2,textvariable=SelValue2,background="white")
	word.adjp3=tklabel(frame1c.3,textvariable=SelValue3,background="white")

	SelValueNum=tclVar("Yet to be generated.");
	word.geneLabel=  tklabel(frame1d,text="The number of genes left after cutoff: ")
	word.geneNum=  tklabel(frame1d,textvariable=SelValueNum)
#middle layout
	tkgrid(label1.1,sticky="es");
	tkgrid(frame1o);
	tkgrid(label1.10,sticky="w");
	tkgrid(frame2o,sticky="w");

	tkgrid(tl1.1,scr1.1);tkgrid.configure(scr1.1,rowspan=10,sticky="nsw")
	tkgrid(but1.1);	tkgrid(but1.2);
	tkgrid(tl1.2,scr1.2);tkgrid.configure(scr1.2,rowspan=5,sticky="nsw")
	tkgrid(but1.3,but1.4);
	tkgrid(frame1a.31);tkgrid(frame1a.32);
	tkgrid(frame1a.1,frame1a.2,frame1a.3,sticky="w");tkgrid.configure(frame1a.1,frame1a.3,sticky="nw")
	tkgrid(frame1a,sticky="w");
	
	tkgrid(label3.1,sticky="we");
	tkgrid(word.tip);
	tkgrid(cb1,word.fc,entry.fc,word.fc2,word.fc3)
	tkgrid(cb2,word.p,entry.p,word.p2,word.p3)
	tkgrid(cb3,word.adjp,entry.adjp,word.adjp2,word.adjp3)
	
	tkconfigure(entry.fc,state="disabled");
	tkconfigure(entry.p,state="disabled");
	tkconfigure(entry.adjp,state="disabled");
	
	tkgrid(word.geneLabel,word.geneNum,sticky="we");
	tkgrid(frame1c.0,sticky="we"); tkgrid(frame1c.1,sticky="we");	tkgrid(frame1c.2,sticky="we");	tkgrid(frame1c.3,sticky="we");
	tkgrid(frame1c0); tkgrid(frame1c);tkgrid(frame1d);

##################################################################
#bottom
	Check.but <-tkbutton(frame2,text="Check numbers",command=OnCheck,width=15);
	Gene.but <-tkbutton(frame2,text="Generate gene list",command=OnOK,width=15)
	Cancel.but <-tkbutton(frame2,text="Cancel",command=OnCancel,width=15)

#bottom layout
 	tkgrid(Check.but,Gene.but,Cancel.but);
##################################################################
#layout frame
	tkgrid(frame0);
	tkgrid(frame1);
	tkgrid(frame2);
	tkgrid(FrameMain1);tkgrid(FrameMain2);
	tkfocus(tt.sub)
	tkwait.window(tt.sub)
	return(list(ReturnValue=tclvalue(ReturnValue),colnames=Sel.colname.list,
			SelFc=tclvalue(cbValue1),SelP=tclvalue(cbValue2),SelAdjP=tclvalue(cbValue3),
			Fc=tclvalue(InputValue1),P=tclvalue(InputValue2),AdjP=tclvalue(InputValue3),
			colFc=tclvalue(SelValue1),colP=tclvalue(SelValue2),colAdjP=tclvalue(SelValue3))
		);
}
#Input.SAM.GeneList()