FindAnnTable<-function(prefix=data.raw@annotation)
{
Try({
	db=paste(prefix,".db",sep="");
	library(db,character.only = TRUE)
	out.list=c("SYMBOL","GENENAME","ENTREZID","REFSEQ","ENSEMBL","UNIGENE","UNIPROT");
	prefix.out.list=paste(prefix,out.list,sep="")
	AnnoTable=NULL;
	for(i in 1:length(out.list))
	{
		tmp1=as.list(get(prefix.out.list[i]));
		if(i==1)
		{
		AnnoTable=cbind(names(tmp1),as.character(tmp1))
		colnames(AnnoTable)=c("PROBEID",out.list[i]);
		}else{
		AnnoTable=cbind(AnnoTable,as.character(tmp1))
		colnames(AnnoTable)[i+1]=out.list[i];
		}
	}

	#Split Refseq function;
	split.string<-function(x)
	{
	tmp0=unlist(strsplit(x,split="\"",fixed=TRUE))
	if(length(tmp0)>1) 
	{
		tmp1=tmp0[-c(1,length(tmp0))]
	}else{
		tmp1=tmp0;
	}
	out.tmp=paste(tmp1[which(tmp1!=" ")],collapse = ",")
	return(out.tmp)
	}

	#convert;
	convert.list=c("REFSEQ","ENSEMBL","UNIGENE","UNIPROT")
	for(i in 1:length(convert.list))
	{
		tmp1=strsplit(as.character(AnnoTable[,convert.list[i]]),",")
		tmp2=lapply(tmp1,split.string)
		AnnoTable[,convert.list[i]]=as.character(as.matrix(tmp2))
	}
	Feature.Name=as.data.frame(featureNames(data.raw));
	names(Feature.Name)="PROBEID";
	tmp=merge(Feature.Name,AnnoTable,by.x="PROBEID",all.x=T);
	return(tmp)
});
}
Affy.Anno <-function()
{
Try({
# gene Annotation
	sel=tclvalue(UsedCDF)
	if(sel=="Affy_CDF")
	{
		tmp.list=ls(envir=.GlobalEnv)
		sel="biocinstall" %in% tmp.list;
		if(!sel) 
		{
			source("http://bioconductor.org/biocLite.R")
		}
	#get the installed packages
		a=library();
		InLib=a$results[,1];
		prefix=data.raw@annotation;
		
	switch(as.character(prefix),
##################################
		"hugene10stv1"={
			sel=tclvalue(tkmessageBox(message="Which Type do you need for Annotation?\nChoose Yes if you want to use transcript. \nChoose No if you want to use probeset.",
			icon="question",type="yesnocancel",default="yes"));
			if(sel=="cancel") return();
			if(sel=="yes") 
			{
				prefix="hugene10sttranscriptcluster";
			}else{
				prefix="hugene10stprobeset";
			}
			dbpackage=paste(prefix,".db",sep="");
			Try({
				if(!(dbpackage %in% InLib))
				{
				biocLite(dbpackage)
				}
				data.anno<<-FindAnnTable(prefix)
				tclvalue(Anno.Bool)="Done";
			});
		},
		"mogene10stv1"={
			sel=tclvalue(tkmessageBox(message="Which Type do you need for Annotation?\nChoose Yes if you want to use transcript. \nChoose No if you want to use probeset.",
			icon="question",type="yesnocancel",default="yes"));
			if(sel=="cancel") return();
			if(sel=="yes") 
			{
				prefix="mogene10sttranscriptcluster";
			}else{
				prefix="mogene10stprobeset";
			}
			dbpackage=paste(prefix,".db",sep="");
			Try({
				if(!(dbpackage %in% InLib))
				{
				biocLite(dbpackage)
				}
				data.anno<<-FindAnnTable(prefix)
				tclvalue(Anno.Bool)="Done";
			});
		},
		"ragene10stv1"={
			sel=tclvalue(tkmessageBox(message="Which Type do you need for Annotation?\nChoose Yes if you want to use transcript. \nChoose No if you want to use probeset.",
			icon="question",type="yesnocancel",default="yes"));
			if(sel=="cancel") return();
			if(sel=="yes") 
			{
				prefix="ragene10sttranscriptcluster";
			}else{
				prefix="ragene10stprobeset";
			}
			dbpackage=paste(prefix,".db",sep="");
			Try({
				if(!(dbpackage %in% InLib))
				{
				biocLite(dbpackage)
				}
				data.anno<<-FindAnnTable(prefix)
				tclvalue(Anno.Bool)="Done";
			});
		},
###############################
		"huex10stv2"={
			tkmessageBox(message="The Annotation DB is not available yet",icon="info",type="ok");
		},
		"moex10stv1"={
			tkmessageBox(message="The Annotation DB is not available yet",icon="info",type="ok");
		},
		"raex10stv1"={
			tkmessageBox(message="The Annotation DB is not available yet",icon="info",type="ok");
		},
##############################
		{
			Try({
				db=paste(prefix,".db",sep="");
				if(!(db %in% InLib))
				{
				biocLite(db)
				}
				data.anno<<-FindAnnTable(prefix)
				tclvalue(Anno.Bool)="Done";
			});
		});
######################
	}else if(sel=="Dai_ENTREZG_CDF")
	{
		chiptype=tclvalue(ChipType)
		CDFmapping=read.csv(file=paste(tclvalue(Path),"//Source//CdfAnnoMapping.csv",sep=""),header=T);
		newdb=as.character(CDFmapping[as.character(CDFmapping$Affy_CDF)==chiptype,"Dai_ENTREZG_Anno"]);
		
		prefix=substring(newdb,1,nchar(newdb)-3)
		data.anno<<-FindAnnTable(prefix)
		tclvalue(Anno.Bool)="Done";

	}else if(sel=="Dai_REFSEQ_CDF")
	{
		chiptype=tclvalue(ChipType)
		CDFmapping=read.csv(file=paste(tclvalue(Path),"//Source//CdfAnnoMapping.csv",sep=""),header=T);
		newdb=as.character(CDFmapping[as.character(CDFmapping$Affy_CDF)==chiptype,"Dai_REFSEQ_Anno"]);
		
		prefix=substring(newdb,1,nchar(newdb)-3)
		data.anno<<-FindAnnTable(prefix)
		tclvalue(Anno.Bool)="Done";
	}else if(sel=="GAT_Explorer_Gene_CDF")
	{
		chiptype=tclvalue(ChipType);
		sel1=sum(chiptype==c("HG-U133A","HG-U133A_2","HG-U133B","HG-U133_Plus_2","HG_U95A,HG_U95Av2","HG-Focus","HuGene-1_0-st-v1","HuEx-1_0-st-v2"));
		sel2=sum(chiptype==c("MG_U74Av2","MG_U74Bv2","MG_U74Cv2","Mouse430_2","Mouse430A_2","MOE430A","MOE430B","MoGene-1_0-st-v1","MoEx-1_0-st-v1"));
		sel3=sum(chiptype==c("RG_U34A","Rat230_2","RAE230A","RAE230B","RaGene-1_0-st-v1","RaEx-1_0-st-v1"));
		if(sel1) filename="genes-human-annotation.new.csv";
		if(sel2) filename="genes-mouse-annotation.csv";
		if(sel3) filename="genes-rat-annotation.csv";
		AnnoMap=read.csv(file=paste(tclvalue(Path),"//data//anno//",filename,sep=""),header=T);

		Feature.Name=as.data.frame(featureNames(data.raw));
		names(Feature.Name)="gene";
		tmp=merge(Feature.Name,AnnoMap,by.x="gene",all.x=T);
		if(sel1)
		{
			list1=c("gene","gene","gene_symbol","gene_description","gene_id");
			list2=c("PROBEID","ENSEMBL","SYMBOL","GENENAME","ENTREZID");
		}else{
			list1=c("gene","gene","gene_symbol","gene_description");
			list2=c("PROBEID","ENSEMBL","SYMBOL","GENENAME");
		}
		tmp=tmp[,list1];
		names(tmp)=list2;
		data.anno<<-tmp;
		tclvalue(Anno.Bool)="Done";
	}else if(sel=="GAT_Explorer_Transcript_CDF")
	{
		chiptype=tclvalue(ChipType);
		sel1=sum(chiptype==c("HG-U133A","HG-U133A_2","HG-U133B","HG-U133_Plus_2","HG_U95A,HG_U95Av2","HG-Focus","HuGene-1_0-st-v1","HuEx-1_0-st-v2"));
		sel2=sum(chiptype==c("MG_U74Av2","MG_U74Bv2","MG_U74Cv2","Mouse430_2","Mouse430A_2","MOE430A","MOE430B","MoGene-1_0-st-v1","MoEx-1_0-st-v1"));
		sel3=sum(chiptype==c("RG_U34A","Rat230_2","RAE230A","RAE230B","RaGene-1_0-st-v1","RaEx-1_0-st-v1"));
		if(sel1) filename="transcripts-human-annotation.new.csv";
		if(sel2) filename="transcripts-mouse-annotation.csv";
		if(sel3) filename="transcripts-rat-annotation.csv";
		AnnoMap=read.csv(file=paste(tclvalue(Path),"//data//anno//",filename,sep=""),header=T);
		
		Feature.Name=as.data.frame(featureNames(data.raw));
		names(Feature.Name)="transcript";
		tmp=merge(Feature.Name,AnnoMap,by.x="transcript",all.x=T);
		if(sel1)
		{
			list1=c("transcript","transcript","gene","gene_symbol","gene_description","gene_id");
			list2=c("PROBEID","ENST","ENSEMBL","SYMBOL","GENENAME","ENTREZID");
		}else{
			list1=c("transcript","transcript","gene","gene_symbol","gene_description");
			list2=c("PROBEID","ENST","ENSEMBL","SYMBOL","GENENAME");
		}
		tmp=tmp[,list1];
		names(tmp)=list2;
		data.anno<<-tmp;
		tclvalue(Anno.Bool)="Done";
	}else{
		data.anno<<-NULL
		tkmessageBox(message="The Annotation of the CDF you selected is not supported now!");
		tclvalue(Anno.Bool)="Not Supported";
	}
});
}

################################################################################################
Annotation.info<-function(anno.data,lib.1,Species.Choice)
{
	Feature.Name<-featureNames(data.eset)
	nuIDs<-featureNames(anno.data)
	gene.Symbol<-getSYMBOL(nuIDs,lib.1)
      gene.Name<- sapply(lookUp(nuIDs,lib.1, 'GENENAME'), function(x) x[1])
	gene.RefSeq<-sapply(lookUp(nuIDs,lib.1,'REFSEQ'), function(x) x[1])
	gene.ensembl<-sapply(lookUp(nuIDs,lib.1,'ENSEMBL'), function(x) x[1])
	gene.entrezid<-sapply(lookUp(nuIDs,lib.1,'ENTREZID'), function(x) x[1])
	#gene.chrloc<-sapply(lookUp(nuIDs,lib.1,'CHRLOC'), function(x) x[1])
	gene.UNIGENE<-sapply(lookUp(nuIDs,lib.1,'UNIGENE'), function(x) x[1])
	gene.UNIPROT<-sapply(lookUp(nuIDs,lib.1,'UNIPROT'), function(x) x[1])

	#"PROBEID"  "SYMBOL"   "GENENAME" "ENTREZID" "REFSEQ"   "ENSEMBL" "UNIGENE"  "UNIPROT"

	chip.info=getChipInfo(anno.data, species=Species.Choice)
	AnnoTable=cbind(Feature.Name,gene.Symbol,gene.Name,gene.entrezid,gene.RefSeq,gene.ensembl,gene.UNIGENE,gene.UNIPROT);
	colnames(AnnoTable)=c("PROBEID","SYMBOL","GENENAME","ENTREZID","REFSEQ","ENSEMBL","UNIGENE","UNIPROT")
	data.anno<<-data.frame(AnnoTable,row.names=NULL)
	tclvalue(ChipType)=chip.info$species;
	tclvalue(UsedCDF)=paste(chip.info$chipVersion,collapse="_OR_");
}

Illumina.Anno<-function()
{
	tmp0=getChipInfo(data.raw)
	Orginism=tmp0$species;
      tmp_rep=tkmessageBox(message=paste("The software detected that the organism of the chips is ",Orginism,".\nIs this right? Click NO for other species.",sep=""),type="yesno");	
	if(tclvalue(tmp_rep)=="no"){
		Orginism=select.list(c("Human","Mouse","Rat"))
	}
	if(Orginism=="") return();
	tclvalue(ChipType)=Orginism;
	conn=get(paste("lumi",Orginism,"IDMapping_dbconn",sep=""))()
	Tables=dbListTables(conn)
	Tables=Tables[grepl(Orginism,Tables)];

	Chip.version=tmp0$chipVersion
	if (length(Chip.version)>1) Chip.version=Chip.version[length(Chip.version)];
	if(is.null(Chip.version))
	{
		tkmessageBox(message="Chips info is not self-contained in this dataset!\nPlease select the proper chip version.");
		Chip.version=select.list(Tables);
		if(Chip.version=="") return();
	}
	Table.info=dbReadTable(conn,Chip.version)
	Illumina.Default=Table.info[,c("Symbol","Accession")]
	Illumina.Default=cbind(Table.info[,grep("probe",tolower(colnames(Table.info)))],Illumina.Default)
	colnames(Illumina.Default)=c("PROBEID","SYMBOL","REFSEQ")
	data.anno<<-data.frame(Illumina.Default,row.names=NULL)
} 
#ReAnnotation by Pan Du
Lumi.ReAnno.nuID<-function()
{
Try({
	Feature.Name<-featureNames(data.eset)
	tmp=sapply(Feature.Name,is.nuID);
	jug=(sum(tmp)==length(tmp))
		
	chip.tmp=getChipInfo(data.eset)
	Orginism=chip.tmp$species;
      tmp_rep=tkmessageBox(message=paste("The software detected that the organism of the chips is ",Orginism,".\nIs this right? Click NO for other species.",sep=""),type="yesno");	
	if(tclvalue(tmp_rep)=="no"){
		Orginism=select.list(c("Human","Mouse","Rat"))
	}
	tclvalue(ChipType)=Orginism;
	Species=c("Human","Mouse","Rat")

	if (Species[1]==Orginism)
	{
		Spe.choose=Species[1];
		lib.1<-"lumiHumanAll.db"
		lib.2<-"lumiHumanIDMapping"
	}else if (Species[2]==Orginism)
	{
		Spe.choose=Species[2];
		lib.1<-"lumiMouseAll.db"
		lib.2<-"lumiMouseIDMapping"
	}else if (Species[3]==Orginism)
	{
		Spe.choose=Species[3];
		lib.1<-"lumiRatAll.db"
		lib.2<-"lumiRatIDMapping"
	}else{tkmessageBox(message="The program did not find matched model organism to your data!");return();}

	if(!jug) # don't have nuID, Annotation Using Inside library
	{	
		x.lumi.nuID<-addNuID2lumi(data.eset,lib.mapping=lib.2);
		Annotation.info(x.lumi.nuID,lib.1,Spe.choose);
		tkmessageBox(message="Annotation completed!");
	}else # if data has nuID
	{
		#tkmessageBox(message="The data is already nuID annotated!")
		Annotation.info(data.eset,lib.1,Spe.choose)
		tkmessageBox(message="Annotation completed!");
	}
});
}

