Annotation_WG.info<-function(Orginism,version)
{
Try({
	out.list=c("SYMBOL","GENENAME","ENTREZID","REFSEQ","ENSEMBL","UNIGENE","UNIPROT")
	db.list=list();
	map.list=list()
	db.out=list()
	for(i in 1:length(out.list))
	{
		Chip.info=paste("illumina",Orginism,version,out.list[i],sep="");
		db.list[[i]]=get(Chip.info);
	}   
	names(db.list)=c("gene.symbol.db","gene.names.db","entrezid.db",
			"refseq.db","ensembl.db","unique.gene.db","uniprot.db")
	for (i in 1:length(db.list))
	{
		map.list[[i]]<-mappedkeys(db.list[[i]])
		names(map.list)[i]=out.list[i]
		db.out[[i]]=as.list(db.list[[i]][as.character(unlist(map.list[i]))])
		names(db.out)[i]=out.list[i]
	}
	namelist=unique(sort(c(names(db.out$SYMBOL),names(db.out$GENENAME),
			names(db.out$ENTREZID),names(db.out$REFSEQ),names(db.out$ENSEMBL),
			names(db.out$UNIGENE),names(db.out$UNIPROT))))

	anno.info=matrix(NA,length(namelist),length(db.out))
	rownames(anno.info)=namelist
	colnames(anno.info)=out.list	
	for (i in 1:length(db.out))
	{
		anno.info[match(names(db.out[[i]]),namelist),i]=as.character(db.out[[i]])
	}
	Feature.Name=featureNames(data.raw)
	index=row.names(anno.info)%in%Feature.Name
	anno.out=anno.info[index,];
	AnnoTable=cbind(rownames(anno.out),anno.out)
	colnames(AnnoTable)[1]="PROBEID";
	#Split Refseq function;
	split.string<-function(x)
	{
		tmp0=unlist(strsplit(x,split="\"",fixed=TRUE))
		if(length(tmp0)>1) 
		{
			tmp1=tmp0[-c(1,length(tmp0))]
		}else{
			tmp1=tmp0;
		}
		out.tmp=paste(tmp1[which(tmp1!=" ")],collapse = ",")
		return(out.tmp)
	}

	#convert;
	convert.list=c("REFSEQ","ENSEMBL","UNIGENE","UNIPROT")
	for(i in 1:length(convert.list))
	{
		tmp1=strsplit(as.character(AnnoTable[,convert.list[i]]),",")
		tmp2=lapply(tmp1,split.string)
		AnnoTable[,convert.list[i]]=as.character(as.matrix(tmp2))
	}

	return(data.frame(AnnoTable));
});
}

#ReAnnotation by Mark Dunning
illumi.ReAnno.MD<-function()
{
Try({
	tmp=getChipInfo(data.eset)
	Orginism=tmp$species;
	version=tolower(tmp$chipVersion);
	tmp_manual=tclVar();
	tmp_rep=tclVar()
	if(length(version)!=0) 
	{	
      	if(length(version)>1) version=version[1];
     		tmp_rep=tkmessageBox(message=paste("The software detected that the chip info is ",Orginism,"\nIs this right? Click NO for other options.",sep=""),type="yesno");
	}
	if(length(version)==0)
	{
     		tmp_manual=tkmessageBox(message="The chip type is not automatically detected.\nPlease click YES to manually specify the chip type.\nOr click NO to cancel this step.",type="yesno");
	}
	if(tclvalue(tmp_manual)=="no") return();
	if(tclvalue(tmp_rep)=="no" | tclvalue(tmp_manual)=="yes")
	{
		tkmessageBox(message="Please select the organism");
		Orginism=select.list(c("Human","Mouse","Rat"))
		if(Orginism=="") return();
		tclvalue(ChipType)=Orginism;
		conn=get(paste("lumi",Orginism,"IDMapping_dbconn",sep=""))();
		Tables=dbListTables(conn);
		Tables=Tables[grepl(Orginism,Tables)];
		Tables=Tables[!grepl("HT",Tables)]
		tkmessageBox(message="Please select the proper chip version.");
		version=tolower(select.list(Tables));
		if(version=="") return();
	}

	v="";
	if(all(grepl("v1",version)))
	{
	v="v1";
	}else if(all(grepl("v2",version)))
	{
	v="v2"
	}else if(all(grepl("v3",version))) 
	{
	v="v3"
	}
	if(v!="" & Orginism!="")
	{
		Try({
			lib.name=paste("illumina",Orginism,v,".db",sep="")
			library(lib.name,character.only=T);
			data.anno<<-Annotation_WG.info(Orginism=Orginism,version=v)
		});
	}else{
		tkmessageBox(message="ReAnnotation has failed! \n");
	}
});
}
