# Create a New Project
# user will provide the name of a project
# it can't be the same to the old projects' names
# the full path of the project folder will be outputed
# the folder of the "Project Name" ,
# will be created if they do not exist.	  

CreateNewProject<-function()
{
Try({
	tkconfigure(tt,cursor="watch");	
	project=Input.CreateNewProject();
	if(as.numeric(project$ReturnValue)!=1) {tkconfigure(tt,cursor="arrow");tkfocus(tt);return();}
	project$path=gsub("\\\\","/",project$path);
	tmp.project=unlist(strsplit(project$path,"/"));
	tmp.project[1]=toupper(tmp.project[1]);
	project.name=tmp.project[length(tmp.project)];
	project.path=paste(tmp.project[-length(tmp.project)],collapse = "/")
	if(project.name!="" & project.path!="")
	{
		project.file=paste(project.path,"/",project.name,"/",project.name,".prj",sep="")
		path.project=paste(project.path,"/",project.name,sep="")
		if(file.exists(project.file))
		{
		tkmessageBox(message="Project Exist! No Project Will be Created!");
		}else{
		if(!file.exists(path.project)) dir.create(path.project,recursive = T)
		path.output=paste(path.project,"/Output",sep="")
		if(!file.exists(path.output)) dir.create(path.output)

		Init(path);
				
		tclvalue(Project.Name)=project.name;
		tclvalue(Path.project)=path.project;

		path.output=paste(path.project,"/Output",sep="")
		tclvalue(Path.output)=path.output
		UpStage(2);
		a=GetProperty();
		write.table(a,file=paste(path.project,"/",project.name,".prj",sep=""),quote=T,col.names=F,sep="\t");
		save(data.info,data.raw,data.eset,out,data.anno,ga.output,file=paste(tclvalue(Path.project),"/",tclvalue(Project.Name),".Rdata",sep=""));
		setwd(tclvalue(Path.project));

		readfile=paste(path.project,"/",project.name,".prj",sep="");
		recentFilesFileName=paste(tclvalue(Path),"/Source/RecentFiles.txt",sep="");
		recentFiles=readLines(recentFilesFileName);
		if(readfile %in% recentFiles)
		{
			recentFiles=c(readfile,recentFiles[-which(readfile==recentFiles)]);
		}else{
			recentFiles=c(readfile,recentFiles);
			maxline=min(length(recentFiles),5);
		recentFiles=recentFiles[1:maxline];
		}
		#print(recentFiles);
		writeLines(recentFiles,con=recentFilesFileName);
		LoadRecentMenu();
		}
	}else{
		tkmessageBox(message="Input format was incorrect! No Project Will be Created!");
	}
	tkconfigure(tt,cursor="arrow");
});
}