########### Affy Quality Assessement and outlier detection #########

Affy.QC<-function()
{
	tmp=tclvalue(UsedCDF);
	if(tmp=="Affy_CDF")
	{
		
		an=Input.Affy.QC();
		if(as.numeric(an$ReturnValue)!=1) return();

#################################################################################
#there are warnings for the output size: see the following                      #
#http://www.mentby.com/Group/bioconductor-list/                                 #
#arrayqualitymetrics-binning-grid-too-coarse-for-current-small-bandwidth.html   #
#################################################################################

		if(an$QCsel=="ArrayQualityMetrics" | an$QCsel=="Both")
		{
			Try({	
				path.output=paste(tclvalue(Path.project),"/QC",sep="");
				QC.path="/QC_arrayQualityMetrics_Report";
				output_path2=paste(path.output,QC.path,sep="");
				if(!file.exists(output_path2)) dir.create(output_path2,recursive=T)
				arrayQualityMetrics(expressionset=data.raw,
                    		outdir = output_path2,
                    		force = T,
                    		do.logtransform = F,
			  		spatial = TRUE)
			});
		}
		if(an$QCsel=="QCReport" | an$QCsel=="Both")
		{
		Try({
			path.output=paste(tclvalue(Path.project),"/QC",sep="");
			QCname=paste(path.output,"/QCReport",sep="")
			if(!file.exists(QCname)) dir.create(QCname,recursive=T)
			setwd(QCname);
			setQCEnvironment(cleancdfname(cdfName(data.raw)))
			QCReport(data.raw,file="QCReport.pdf")
			#dev.off();
			setwd(tclvalue(Path.project));
		});
		}
	UpStage(11);
	}else{tkmessageBox(message="QC of data with custom CDF is not supported.")
}
}

##########################################################################
QC_lumi<-function(data_in,path.output,QC.out){
	lumi.Q=lumiQ(data_in,logMode=T,detectionTh=0.01);
	#logMode:determine whether the data is on log2 scale;
	summary(lumi.Q,'QC');
	#the summary information already did adjustment to force negative value being postive;



	#generate several plots based on QC;
	pdf(file=paste(path.output,QC.out,"/QC.report.pdf",sep=""))
	plot(lumi.Q,what="density",logMode=T,main="");
	mtext("Density plot on the log 2 scale of data.",side=3,line=2,adj=0,col="blue",cex=0.8,font=4)

	plotCDF(lumi.Q,reverse=F,logMode=T,main="");
	#logMode:determine whether the CDF plot is based on a log2 scale;
	mtext("Culmulative density of sample intensities on log 2 scale.",col="blue",side=3,line=2,adj=0,font=4,cex=0.8)

	plot(lumi.Q,what="boxplot",main="",logMode=T,standardize=T,col="bisque",subset=NULL);
	mtext("Boxplot of sample intensities on log 2 scale.",
	side=3,line=1,adj=0,col="blue",font=4,cex=0.8)


	#plot(lumi.Q,what="sampleRelation",method="cluster",main="",standardize=T,dimension=c(1,2),cex.main=1.0);
      #mtext("This shows the relation between samples.The defalut method is hierarchical \n clustering.",col="blue",side=1,line=2,adj=0,font=4,cex=0.8)

	x.outlier=detectOutlier(lumi.Q,metric="euclidean",standardize=TRUE,Th=2,ifPlot=T);
	mtext("Outlier detection graph.Default criteria: 2*median distance to the center. \n Default distance measurement: euclidean distance",col="blue",side=1,line=2,adj=0,font=4,cex=0.8)


	#dimension:the principle components to visualize the MDS plot 
	#method="cluster" and "mds";
	#color:option can only be used for mds method;

	plot(lumi.Q,what="pair",logMode=TRUE,main="",subset=NULL,fold=2);
	mtext("Pairwise relation between sample intensities.In the little box, it shows \n how many probes are up and down regulated. Criteria: fold change 2",col="blue",side=3,line=2,adj=0,font=4,cex=0.8)

	#fold:The fold-change threshold used to estimate the number of probes having high fold-changes;
	#subset:subset of rows used to plot;
	dev.off();
}
Lumi.QC<-function()
{
	path.output=paste(tclvalue(Path.project),"/QC",sep="");
	QC.path="/QC_Report";
	output_path2=paste(path.output,QC.path,sep="");
	if(!file.exists(output_path2)) dir.create(output_path2,recursive=T);
	tkmessageBox(message="Quality Control Analysis begins!")
	QC_lumi(data.raw,path.output,QC.path)
	UpStage(11);
}

##########################################################################

QC<-function()
{
Try({
	if(as.numeric(tclvalue(Stage))<10)
	{
		tkmessageBox(message="Please select the project first!");
		return();
	}
	tkconfigure(tt,cursor="watch")	

	if(tclvalue(Data.Type)=="Affy Data(*.CEL)")
	{
	Affy.QC()
	}else if(tclvalue(Data.Type)=="Illumina Data(non-preprocessed)") {
	tkconfigure(tt,cursor="watch")
	Lumi.QC()
	}else{tkmessageBox(message="Please Make sure you finished the previous steps!")}
	tkconfigure(tt,cursor="arrow")	
});
}