
\name{huex10stv2hsrefseq_dbconn}

\alias{huex10stv2hsrefseq_dbconn}
\alias{huex10stv2hsrefseq_dbfile}
\alias{huex10stv2hsrefseq_dbschema}
\alias{huex10stv2hsrefseq_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  huex10stv2hsrefseq_dbconn()
  huex10stv2hsrefseq_dbfile()
  huex10stv2hsrefseq_dbschema(file="", show.indices=FALSE)
  huex10stv2hsrefseq_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{huex10stv2hsrefseq_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{huex10stv2hsrefseq_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{huex10stv2hsrefseq_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{huex10stv2hsrefseq_dbschema} prints the schema definition of the
  package annotation DB.

  \code{huex10stv2hsrefseq_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{huex10stv2hsrefseq_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{huex10stv2hsrefseq_dbfile}: a character string with the path to the
  package annotation DB.

  \code{huex10stv2hsrefseq_dbschema}: none (invisible \code{NULL}).

  \code{huex10stv2hsrefseq_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "probes" table:
  dbGetQuery(huex10stv2hsrefseq_dbconn(), "SELECT COUNT(*) FROM probes")

  ## The connection object returned by huex10stv2hsrefseq_dbconn() was
  ## created with:
  dbConnect(SQLite(), dbname=huex10stv2hsrefseq_dbfile(), cache_size=64000,
  synchronous=0)

  huex10stv2hsrefseq_dbschema()

  huex10stv2hsrefseq_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

