datacache <- new.env(hash=TRUE, parent=emptyenv())

huex10stv2hsentrezg <- function() showQCData("huex10stv2hsentrezg", datacache)
huex10stv2hsentrezg_dbconn <- function() dbconn(datacache)
huex10stv2hsentrezg_dbfile <- function() dbfile(datacache)
huex10stv2hsentrezg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
huex10stv2hsentrezg_dbInfo <- function() dbInfo(datacache)

huex10stv2hsentrezgORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "huex10stv2hsentrezg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "huex10stv2hsentrezg", "chip huex10stv2hsentrezg", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(huex10stv2hsentrezg_dbconn())
}

