datacache <- new.env(hash=TRUE, parent=emptyenv())

rgu34arnentrezg <- function() showQCData("rgu34arnentrezg", datacache)
rgu34arnentrezg_dbconn <- function() dbconn(datacache)
rgu34arnentrezg_dbfile <- function() dbfile(datacache)
rgu34arnentrezg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
rgu34arnentrezg_dbInfo <- function() dbInfo(datacache)

rgu34arnentrezgORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "rgu34arnentrezg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "rgu34arnentrezg", "chip rgu34arnentrezg", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(rgu34arnentrezg_dbconn())
}

