datacache <- new.env(hash=TRUE, parent=emptyenv())

mouse4302mmrefseq <- function() showQCData("mouse4302mmrefseq", datacache)
mouse4302mmrefseq_dbconn <- function() dbconn(datacache)
mouse4302mmrefseq_dbfile <- function() dbfile(datacache)
mouse4302mmrefseq_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
mouse4302mmrefseq_dbInfo <- function() dbInfo(datacache)

mouse4302mmrefseqORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "mouse4302mmrefseq.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "mouse4302mmrefseq", "chip mouse4302mmrefseq", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(mouse4302mmrefseq_dbconn())
}

