.First.lib <- function(libname, pkgname) {
	require(Biobase) || stop("cannot load farms without Biobase")
	require(affy) || stop("cannot load farms without affy")
    	if(interactive() && .Platform$OS.type == "windows" && .Platform$GUI ==  "Rgui")
        	addVigs2WinMenu("farms")
	cat("\n","Changes in FARMS:","\n",
		"Version 1.3.0: Added I/NI-calls for filtering","\n",
		"Version 1.3.1: Adjusted Hyperparameters for alternative CDFs,","\n",
		"			   probes set standardized, weighted mean", "\n",
		"Version 1.4.0: Works now with R >= 2.8 and Bioconductor 2.3,","\n",
		"			   Changed termination criterion, initialization values,", "\n",
		"			   factors and loadings scaled, added argument robust","\n",
		"For all changes previous to 1.3.0, see the farms vignette.","\n",
		"For updates please check http://www.bioinf.jku.at/software/farms/farms.html","\n"
		,sep="")

upDate.generateExprSet.methods(c(generateExprSet.methods(), "farms"))
upDate.express.summary.stat.methods(c(express.summary.stat.methods(), "farms"))

}
