\name{getI_Eset}
\alias{getI_Eset}
\title{Method to generate an ExpressionSet of informative genes}
\description{
  This function generates an  instance of  \code{\link[Biobase]{exprSet-class}}, that contains only  informative probe sets.
}
\usage{
          getI_Eset(object)
          }
\arguments{
    	\item{object}{An instance of \code{\link[farms]{INIcalls-class}}.}
          }
\value{\code{\link[Biobase]{exprSet-class}}}
\seealso{\code{\link{exp.farms}}, \code{\link{q.farms}},\code{\link{l.farms}},\code{\link{INIcalls}},\code{\link{summary}}}
\examples{
  data(Dilution) 
  eset <- exp.farms(Dilution, bgcorrect.method = "rma", pmcorrect.method = "pmonly", normalize.method = "constant")  
  INIs <- INIcalls(eset)  # apply I/NI calls
  summary(INIs)  
  plotINIs(INIs) # draws a density plot of I/NI-calls
  I_data <- getI_Eset(INIs) # affybatch containing only  informative probe sets
  NI_data <- getNI_Eset(INIs) # affybatch containing only  non-informative probe sets
  I_probes <- getI_ProbeSets(INIs) # vector containing only  informative probe sets names
  NI_probes <- getNI_ProbeSets(INIs) # vector containing only  non-informative probe sets names
}
\keyword{manip}

