\name{l.farms}
\alias{l.farms}
\title{l.farms expression measure}
\description{
  This function converts an instance of \code{\link[affy]{AffyBatch-class}}
  into an instance of \code{\link[Biobase]{exprSet-class}} using a factor analysis model 
  for which a Bayesian Maximum a Posteriori method optimizes the model parameters under 
  the assumption of Gaussian measurement noise. This function is a wrapper for \code{\link[affy]{expresso}} 
  and uses the function \code{\link[affy]{normalize.loess}} for array normalization.
}
\usage{
          l.farms(object, weight, mu, weighted.mean, robust, ...)
          }
\arguments{
    	\item{object}{An instance of \code{\link[affy]{AffyBatch.Rdash.class}}.}
	\item{weight}{Hyperparameter value in the range of [0,1]  which determines the influence of the prior. The default value is 0.5 } 
	\item{mu}{Hyperparameter value which allows to quantify different aspects of 
	potential prior knowledge. Values near zero assumes that most genes do not
	contain a signal, and introduces a bias for loading matrix elements near zero. Default value is 0}
 	\item{weighted.mean}{Boolean flag, that indicates wether a weighted mean or a least square fit is used to summarize the loading matrix. The default value is set to TRUE .}
 	\item{robust}{Boolean flag, that ensures non-constant results. Default value is TRUE.}
	\item{...}{other arguments to be passed to \code{\link[affy]{expresso}}.}
          }
\value{\code{\link[Biobase]{exprSet-class}}}
\details{
  	This function is a wrapper for \code{\link[affy]{expresso}}.}	
\seealso{\code{\link[affy]{expresso}}, \code{\link[farms]{exp.farms}}, \code{\link[farms]{q.farms}}, \code{\link[affy]{normalize.loess}}}
\examples{
  data(Dilution)
  eset <- l.farms(Dilution,  weight=0.5, weighted.mean=TRUE)
}
\keyword{manip}

