\name{plotINIs}
\alias{plotINIs}
\title{Visualizes the distribution of informative / noninformatives genes}
\description{
  This function visualizes the distribution of informative and uninformative genes of a given instance of \code{\link[farms]{INIcalls-class}}.
}
\usage{
          plotINIs(object)
          }
\arguments{
    	\item{object}{An instance of \code{\link[farms]{INIcalls-class}}.}
          }
\value{\code{\link[Biobase]{exprSet-class}}}
\seealso{\code{\link{exp.farms}}, \code{\link{q.farms}},\code{\link{l.farms}},\code{\link{INIcalls}},\code{\link{summary}}}
\examples{
  data(Dilution) 
  eset <- exp.farms(Dilution, bgcorrect.method = "rma", pmcorrect.method = "pmonly", normalize.method = "constant")  
  INIs <- INIcalls(eset)  # apply I/NI calls
  summary(INIs)  
  plotINIs(INIs) # draws a density plot of I/NI-calls
  I_data <- getI_Eset(INIs) # affybatch containing only  informative probe sets
  NI_data <- getNI_Eset(INIs) # affybatch containing only  non-informative probe sets
  I_probes <- getI_ProbeSets(INIs) # vector containing only  informative probe sets names
  NI_probes <- getNI_ProbeSets(INIs) # vector containing only  non-informative probe sets names
}
\keyword{manip}

