datacache <- new.env(hash=TRUE, parent=emptyenv())

hgu133ahsentrezg <- function() showQCData("hgu133ahsentrezg", datacache)
hgu133ahsentrezg_dbconn <- function() dbconn(datacache)
hgu133ahsentrezg_dbfile <- function() dbfile(datacache)
hgu133ahsentrezg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hgu133ahsentrezg_dbInfo <- function() dbInfo(datacache)

hgu133ahsentrezgORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hgu133ahsentrezg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hgu133ahsentrezg", "chip hgu133ahsentrezg", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hgu133ahsentrezg_dbconn())
}

