
\name{hgu133ahsentrezg_dbconn}

\alias{hgu133ahsentrezg_dbconn}
\alias{hgu133ahsentrezg_dbfile}
\alias{hgu133ahsentrezg_dbschema}
\alias{hgu133ahsentrezg_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  hgu133ahsentrezg_dbconn()
  hgu133ahsentrezg_dbfile()
  hgu133ahsentrezg_dbschema(file="", show.indices=FALSE)
  hgu133ahsentrezg_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{hgu133ahsentrezg_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{hgu133ahsentrezg_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{hgu133ahsentrezg_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{hgu133ahsentrezg_dbschema} prints the schema definition of the
  package annotation DB.

  \code{hgu133ahsentrezg_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{hgu133ahsentrezg_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{hgu133ahsentrezg_dbfile}: a character string with the path to the
  package annotation DB.

  \code{hgu133ahsentrezg_dbschema}: none (invisible \code{NULL}).

  \code{hgu133ahsentrezg_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "probes" table:
  dbGetQuery(hgu133ahsentrezg_dbconn(), "SELECT COUNT(*) FROM probes")

  ## The connection object returned by hgu133ahsentrezg_dbconn() was
  ## created with:
  dbConnect(SQLite(), dbname=hgu133ahsentrezg_dbfile(), cache_size=64000,
  synchronous=0)

  hgu133ahsentrezg_dbschema()

  hgu133ahsentrezg_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

