datacache <- new.env(hash=TRUE, parent=emptyenv())

moex10stv1mmrefseq <- function() showQCData("moex10stv1mmrefseq", datacache)
moex10stv1mmrefseq_dbconn <- function() dbconn(datacache)
moex10stv1mmrefseq_dbfile <- function() dbfile(datacache)
moex10stv1mmrefseq_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
moex10stv1mmrefseq_dbInfo <- function() dbInfo(datacache)

moex10stv1mmrefseqORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "moex10stv1mmrefseq.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "moex10stv1mmrefseq", "chip moex10stv1mmrefseq", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(moex10stv1mmrefseq_dbconn())
}

