datacache <- new.env(hash=TRUE, parent=emptyenv())

mouse4302mmentrezg <- function() showQCData("mouse4302mmentrezg", datacache)
mouse4302mmentrezg_dbconn <- function() dbconn(datacache)
mouse4302mmentrezg_dbfile <- function() dbfile(datacache)
mouse4302mmentrezg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
mouse4302mmentrezg_dbInfo <- function() dbInfo(datacache)

mouse4302mmentrezgORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "mouse4302mmentrezg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "mouse4302mmentrezg", "chip mouse4302mmentrezg", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(mouse4302mmentrezg_dbconn())
}

