datacache <- new.env(hash=TRUE, parent=emptyenv())

mogene10stv1mmrefseq <- function() showQCData("mogene10stv1mmrefseq", datacache)
mogene10stv1mmrefseq_dbconn <- function() dbconn(datacache)
mogene10stv1mmrefseq_dbfile <- function() dbfile(datacache)
mogene10stv1mmrefseq_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
mogene10stv1mmrefseq_dbInfo <- function() dbInfo(datacache)

mogene10stv1mmrefseqORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "mogene10stv1mmrefseq.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "mogene10stv1mmrefseq", "chip mogene10stv1mmrefseq", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(mogene10stv1mmrefseq_dbconn())
}

