datacache <- new.env(hash=TRUE, parent=emptyenv())

mgu74av2mmrefseq <- function() showQCData("mgu74av2mmrefseq", datacache)
mgu74av2mmrefseq_dbconn <- function() dbconn(datacache)
mgu74av2mmrefseq_dbfile <- function() dbfile(datacache)
mgu74av2mmrefseq_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
mgu74av2mmrefseq_dbInfo <- function() dbInfo(datacache)

mgu74av2mmrefseqORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "mgu74av2mmrefseq.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "mgu74av2mmrefseq", "chip mgu74av2mmrefseq", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(mgu74av2mmrefseq_dbconn())
}

