datacache <- new.env(hash=TRUE, parent=emptyenv())

rat2302rnrefseq <- function() showQCData("rat2302rnrefseq", datacache)
rat2302rnrefseq_dbconn <- function() dbconn(datacache)
rat2302rnrefseq_dbfile <- function() dbfile(datacache)
rat2302rnrefseq_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
rat2302rnrefseq_dbInfo <- function() dbInfo(datacache)

rat2302rnrefseqORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "rat2302rnrefseq.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "rat2302rnrefseq", "chip rat2302rnrefseq", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(rat2302rnrefseq_dbconn())
}

