
\name{rat2302rnrefseq_dbconn}

\alias{rat2302rnrefseq_dbconn}
\alias{rat2302rnrefseq_dbfile}
\alias{rat2302rnrefseq_dbschema}
\alias{rat2302rnrefseq_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  rat2302rnrefseq_dbconn()
  rat2302rnrefseq_dbfile()
  rat2302rnrefseq_dbschema(file="", show.indices=FALSE)
  rat2302rnrefseq_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{rat2302rnrefseq_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{rat2302rnrefseq_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{rat2302rnrefseq_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{rat2302rnrefseq_dbschema} prints the schema definition of the
  package annotation DB.

  \code{rat2302rnrefseq_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{rat2302rnrefseq_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{rat2302rnrefseq_dbfile}: a character string with the path to the
  package annotation DB.

  \code{rat2302rnrefseq_dbschema}: none (invisible \code{NULL}).

  \code{rat2302rnrefseq_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "probes" table:
  dbGetQuery(rat2302rnrefseq_dbconn(), "SELECT COUNT(*) FROM probes")

  ## The connection object returned by rat2302rnrefseq_dbconn() was
  ## created with:
  dbConnect(SQLite(), dbname=rat2302rnrefseq_dbfile(), cache_size=64000,
  synchronous=0)

  rat2302rnrefseq_dbschema()

  rat2302rnrefseq_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

