datacache <- new.env(hash=TRUE, parent=emptyenv())

hgu95ahsrefseq <- function() showQCData("hgu95ahsrefseq", datacache)
hgu95ahsrefseq_dbconn <- function() dbconn(datacache)
hgu95ahsrefseq_dbfile <- function() dbfile(datacache)
hgu95ahsrefseq_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hgu95ahsrefseq_dbInfo <- function() dbInfo(datacache)

hgu95ahsrefseqORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hgu95ahsrefseq.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hgu95ahsrefseq", "chip hgu95ahsrefseq", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hgu95ahsrefseq_dbconn())
}

