datacache <- new.env(hash=TRUE, parent=emptyenv())

moe430ammentrezg <- function() showQCData("moe430ammentrezg", datacache)
moe430ammentrezg_dbconn <- function() dbconn(datacache)
moe430ammentrezg_dbfile <- function() dbfile(datacache)
moe430ammentrezg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
moe430ammentrezg_dbInfo <- function() dbInfo(datacache)

moe430ammentrezgORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "moe430ammentrezg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "moe430ammentrezg", "chip moe430ammentrezg", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(moe430ammentrezg_dbconn())
}

