/*
 *   Patristic is a Java program that uses as input different tree files
 *   and computes their patristic distances.
 *   Copyright (C) 2005 M Fourment
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *
 * @author  Fourment Mathieu
 */
package Patristic;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import javax.swing.table.TableColumn;
import javax.swing.table.*;
import java.math.BigDecimal;

/**
 * GUI used for the graphic display of the results
 */

public class FrameMatrix extends JFrame {
    public JScrollPane scroll;
    private JTextPane textPane =new JTextPane();
    String[][] data;
    //String[] columnNames;
    Vector columnName;
    JTable table;
    int rowFrom;
    int rowTo;
    int columnFrom;
    int columnTo;
    Matrix localList;
    Vector<String> time=new Vector<String>();
    
    /** Creates a new instance of Diagram */
    public FrameMatrix(Matrix list){
        localList=list;
        for(int i=0;i<list.getDate().length;i++){
            time.addElement(list.getDate()[i]);
        }
        setSize(600,400);
        this.setResizable(true);
        setTitle("Patristic distances: "+list.getFileName()+" (SBL:"+list.getSBL()+")");
        Container pane = this.getContentPane();
        columnName = new Vector(list.getNames().length+1);
        columnName.add("");
//        columnNames=new String[list.getNames().length+1];
//        columnNames[0]="";
        for(int i=0;i<list.getNames().length;i++){
//            columnNames[i+1]=list.getNames()[i];
            columnName.add(list.getNames()[i]);
        }
        
        //table = new JTable(list.toArray(), columnNames);
        MyDefaultTableModel model = new MyDefaultTableModel(list.toArrayVector(),columnName);
        table = new JTable(model);
        table.setModel(model);
        //table = new JTable(list.toArrayVector(), columnName);
        table.getTableHeader().setReorderingAllowed(false);
        //table.setModel(new DefaultTableModel(list.toArray(), columnNames));
//        table.addMouseListener(new java.awt.event.MouseAdapter() {
//            public void mouseReleased(MouseEvent evt) {
//                tableMouseReleased(evt);
//            }
//        });
        table.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(MouseEvent evt) {
                if(evt.getButton() == 1){
                    System.err.println("MOVE");
                    tableMousePressed(evt);
                } else if(evt.getButton() == 3){
                    System.err.println("DELEETE");
                    deleteRow(evt);
                    deleteColumn(evt);
                }
            }
            
            public void mouseReleased(MouseEvent evt) {
                if(evt.getButton() == 1){
                    tableMouseReleased(evt);
                }
            }
            
        });
        
        table.getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        
        table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        scroll = new JScrollPane(table);
        pane.add(scroll,"Center");
        
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                changeMatrix();
            }
        });
    }
    
    private void changeMatrix(){
        localList.setMatrix(toSimpleMatrix());
    }
    
    private void tableMousePressed(MouseEvent evt) {
        rowFrom = table.rowAtPoint(evt.getPoint());
    }
    
    private void deleteRow(MouseEvent evt){
        int row = table.rowAtPoint(evt.getPoint());
        if(time.size() != 0) time.remove(row); // time array
        ((MyDefaultTableModel)table.getModel()).removeRow(row);
        ((MyDefaultTableModel)table.getModel()).fireTableRowsDeleted(row,row);
    }
    
    private void deleteColumn(MouseEvent evt){
        int row = table.rowAtPoint(evt.getPoint());
        //table.removeColumn(table.getColumnModel().getColumn(row));
        
//        // Disable autoCreateColumnsFromModel to prevent
//        // the reappearance of columns that have been removed but
//        // whose data is still in the table model
//        table.setAutoCreateColumnsFromModel(false);
//
//        // Remove the first visible column and its data
        removeColumnAndData(table, row);
    }
    
    public void removeColumnAndData(JTable table, int vColIndex) {
        MyDefaultTableModel model = (MyDefaultTableModel)table.getModel();
        TableColumn col = table.getColumnModel().getColumn(vColIndex+1);
        int columnModelIndex = col.getModelIndex();
        Vector data = model.getDataVector();
        Vector colIds = model.getColumnIdentifiers();
        
        // Remove the column from the table
        table.removeColumn(col);
        
        // Remove the column header from the table model
        colIds.removeElementAt(columnModelIndex);
        
        // Remove the column data
        for (int r=0; r<data.size(); r++) {
            Vector row = (Vector)data.get(r);
            row.removeElementAt(columnModelIndex);
        }
        model.setDataVector(data, colIds);
        
        // Correct the model indices in the TableColumn objects
        // by decrementing those indices that follow the deleted column
        Enumeration enume = table.getColumnModel().getColumns();
        for (; enume.hasMoreElements(); ) {
            TableColumn c = (TableColumn)enume.nextElement();
            if (c.getModelIndex() >= columnModelIndex) {
                c.setModelIndex(c.getModelIndex()-1);
            }
        }
        model.fireTableStructureChanged();
    }
    
    private void tableMouseReleased(MouseEvent evt) {
        rowTo = table.rowAtPoint(evt.getPoint());
        columnTo = table.columnAtPoint(evt.getPoint());
        if(rowTo!=rowFrom && rowTo>-1 && rowTo<table.getRowCount()){
            String element = time.remove(rowFrom);
            if(rowFrom > rowTo){
                System.out.println("1");
                time.insertElementAt(element,rowTo);
            }
            else{                
                System.out.println("22");
                time.insertElementAt(element,rowTo);
            }
            
            ((DefaultTableModel)table.getModel()).moveRow(rowFrom, rowFrom, rowTo);
            table.moveColumn(rowFrom+1, rowTo+1);
            rowFrom=rowTo;
        }
    }
    
    private BigDecimal[][] toSimpleMatrix(){
        BigDecimal [][] temp = new BigDecimal[columnName.size()-1][columnName.size()-1];
        BigDecimal [][] temp2 = new BigDecimal[columnName.size()-1][columnName.size()-1];
        String[] newOrderName=new String[columnName.size()-1];
        //String[] tempDate=new String[columnName.size()-1];
        String[] tempDate=time.toArray(new String[time.size()]);
        
        // name list
        for(int j=0;j<columnName.size()-1;j++){
            newOrderName[j]=((DefaultTableModel)table.getModel()).getValueAt(j,0).toString();
        }
        
        localList.setNames(newOrderName);
        
        // values in the matrix
        for(int i=0;i<columnName.size()-1;i++){
            for(int j=1;j<columnName.size();j++){
                temp[i][j-1]= new BigDecimal(((DefaultTableModel)table.getModel()).getValueAt(i,j).toString());
            }
        }
//
//        for(int j=0;j<newOrderName.length;j++){
//            for(int x=0;x<newOrderName.length;x++){
//                if(newOrderName[j].equals(localList.getNames()[x])){
//                    for(int i=0;i<newOrderName.length;i++) temp2[i][j]=temp[i][x];
//                    break;
//                }
//            }
//        }
        
        // Reorder time
//        for(int j=0;j<newOrderName.length;j++){
//            if(newOrderName[j].equals(localList.getNames()[j])) tempDate[j]=localList.getDate()[j];
//            else{
//                for(int u=0;u<newOrderName.length;u++){
//                    if(newOrderName[j].equals(localList.getNames()[u])){
//                        tempDate[j]=localList.getDate()[u];
//                        break;
//                    }
//                }
//            }
//            
//        }
        
        localList.setDate(tempDate);
        return temp;
    }
    class MyDefaultTableModel extends DefaultTableModel {
        public MyDefaultTableModel(Vector data, Vector names){
            super(data,names);
        }
        public Vector getColumnIdentifiers() {
            return columnIdentifiers;
        }
    }
}

