/*
 *   Patristic is a Java program that uses as input different tree files
 *   and computes their patristic distances.
 *   Copyright (C) 2005 M Fourment
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package Patristic;

import java.util.*;
import java.math.BigDecimal;

/**
 * List of Position object
 */
public class Matrix {
    private String[] names;
    private String[] date;
    private String fileName;
    private int nbTaxon;
    private BigDecimal sbl;
    private BigDecimal[][] matrix;
    
    
    public Matrix(String[] names, String fileName) {
        nbTaxon=names.length;
        matrix=new BigDecimal[nbTaxon][nbTaxon];
        this.names=names;
        this.fileName=fileName;
        this.date=new String[nbTaxon];
        for(int i=0;i<nbTaxon;i++)this.date[i]=String.valueOf("");
    }
    
    public Matrix reOrder(String[] nameOrder){
        BigDecimal [][] temp = new BigDecimal[names.length][names.length];
        BigDecimal [][] temp2 = new BigDecimal[names.length][names.length];
        String[] tempDate=new String[names.length];
        
        // Reorder time
        for(int j=0;j<nameOrder.length;j++){
            if(nameOrder[j].equals(names[j])) tempDate[j]=date[j];
            else{
                for(int u=0;u<nameOrder.length;u++){
                    if(nameOrder[j].equals(names[u])){
                        tempDate[j]=date[u];
                        break;
                    }
                }
            }
            System.out.println(tempDate[j]);
        }
        date=tempDate;
        
        // Horizontal
        for(int j=0;j<nameOrder.length;j++){
            for(int x=0;x<names.length;x++){
                if(nameOrder[j].equals(names[x])){
                    for(int z=0;z<nameOrder.length;z++){
                        temp[z][j]=matrix[z][x];
                    }
                    break;
                }
            }
        }
        // Vertical
        for(int j=0;j<nameOrder.length;j++){
            for(int x=0;x<names.length;x++){
                if(nameOrder[j].equals(names[x])){
                    for(int z=0;z<nameOrder.length;z++){
                        temp2[j][z]=temp[x][z];
                    }
                    break;
                }
            }
        }
        
        matrix=temp2;
        names=nameOrder;
        return this;
    }
    
    // for saving
    public String toMatrix(){
        StringBuffer str=new StringBuffer();
        for(int j=0;j<names.length;j++)str.append(","+names[j]);
        str.append("\r\n");
        for(int i=0;i<nbTaxon;i++){
            str.append(names[i]+",");
            for(int j=0;j<nbTaxon;j++){
                str.append(matrix[i][j]+",");
            }
            str.append("\r\n");
        }
        return str.toString();
    }
    
    // for JTable
    public String[][] toArray(){
        String [][] mat = new String[names.length][names.length+1];
        for(int x=0;x<names.length;x++) mat[x][0]=names[x];
        for(int i=0;i<nbTaxon;i++){
            for(int j=0;j<nbTaxon;j++){
                mat[i][j+1]=matrix[i][j].toString();
            }
        }
        return mat;
    }
    
    // for JTable
    public Vector toArrayVector(){
        Vector mat = new Vector();
        for(int i=0;i<nbTaxon;i++){
            Vector temp = new Vector();
            temp.add(names[i]);
            for(int j=0;j<nbTaxon;j++){
                temp.add(matrix[i][j].toString());
            }
            mat.add(temp);
        }        
        return mat;
    }
    
    public String toColumn(String format){
        StringBuffer str=new StringBuffer();
        for(int i=0;i<nbTaxon;i++){
            for(int j=i+1;j<nbTaxon;j++){
                if(format.compareTo("line")==0){
                    str.append(names[i]+","+names[j]+","+matrix[i][j]+","+"\r\n");
                } else if(format.compareTo("step")==0){
                    
                } else if(format.compareTo("time")==0){
                    int one=0;
                    int two=0;
                    for(int k=0;k<names.length;k++){
                        if(names[i].compareTo(names[k])==0)one=k;
                        if(names[j].compareTo(names[k])==0)two=k;
                    }
                    
                    int date1=new Integer(date[one]).intValue();
                    int date2=new Integer(date[two]).intValue();
                    int diff=Math.abs(date1-date2);
                    str.append(names[i]+","+names[j]+","+matrix[i][j]+","+date[one]+","+date[two]+","+diff+"\r\n");
                    
                }
            }
        }
        return str.toString();
    }
    
    public String toColumnR(){
        StringBuffer str=new StringBuffer();
        str.append(fileName+","+"\r\n");
        for(int i=0;i<nbTaxon;i++){
            for(int j=0;j<nbTaxon;j++){
                str.append(matrix[i][j]+","+"\r\n");
            }
        }
        return str.toString();
    }
    
    public String toDipFormat(boolean addNames){
        StringBuffer str=new StringBuffer();
        int space=0;
        if(addNames){
            for(int j=0;j<names.length;j++)str.append(names[j]+"\r\n");
            str.append("\r\n");
        }
        str.append(fileName+"\r\n");
        int i=0;
        
        for(int x=0;x<names.length;x++){
            if(x<names.length-1)
                for(int d=0;d<space;d++)str.append("\t");
            space++;
            for(int j=x+1;j<names.length;j++){
                str.append("\t"+matrix[x][j]);
            }
            if(x<names.length-1)
                str.append("\r\n");
        }
        return str.toString();
    }
    
    public void addNames(String[] names){
        this.names=names;
    }
    
    public void setDate(String[] date){
        this.date=date;
    }
    
    public void addFileName(String fileName){
        this.fileName=fileName;
    }
    
    public void setMatrix(BigDecimal[][] matrix){
        this.matrix=matrix;
    }
    public void setSbl(BigDecimal sbl){
        this.sbl=sbl;
    }
    public void setNames(String[] names){
        this.names=names;
        nbTaxon=names.length;
    }
    // return the matrix
    public BigDecimal[][] getMatrix(){
        return matrix;
    }
    public String getFileName(){
        return fileName;
    }
    
    public String[] getNames(){
        return names;
    }
    
    public String[] getDate(){
        return date;
    }
    
    public BigDecimal getSBL(){
        return sbl;
    }
    
    
}
