/*
 *   Patristic is a Java program that uses as input different tree files
 *   and computes their patristic distances.
 *   Copyright (C) 2005 M Fourment
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package Patristic;
import java.math.BigDecimal;
import javax.swing.*;
import java.util.*;

import javax.swing.event.*;
import java.io.Serializable;
import java.util.EventListener;
/**
 *
 * @author  mateofourbe
 */
public class PlotModel{
    private BigDecimal maxXGraph,maxXReal,maxYGraph,maxYReal;
    private BigDecimal theMax;
    private BigDecimal minXGraph,minXReal,minYGraph,minYReal;
    private BigDecimal unitX,unitY;
    private BigDecimal minNotZeroX,minNotZeroY;
    private BigDecimal rateMutation;
    private BigDecimal invRate;
    private BigDecimal correlation;
    private String formula;
    private String std;
    private String dotSize;
    private Matrix list1;
    private Matrix list2;
    private PlotList plotList;
    private static final int LINELENGTH=400;
    private static final BigDecimal LINELENGTH_BIG=new BigDecimal(String.valueOf(LINELENGTH));
    private boolean isRegress=false;
    private boolean isCaption=false;
    private  EventListenerList listenerList = new EventListenerList();
    
    BigDecimal maxTime=new BigDecimal("0");
    BigDecimal minTime=new BigDecimal("22222220");
    BigDecimal timeRange=new BigDecimal("0");
    
    BigDecimal[] slope;
    BigDecimal[] intercept;
    BigDecimal meanStat;
    BigDecimal xStd;
    /** Creates a new instance of OptionObject */
    public PlotModel(Matrix list1,Matrix list2) {
        this.list1=list1;
        this.list2=list2;
        init();
    }
    
    /** Creates a new instance of OptionObject */
    public PlotModel(Matrix list1) {
        this.list1=list1;
        this.list2=null;
        initTime();
    }
    
    public PlotList getPlotList(){
        return plotList;
    }
    
    public Matrix getList1(){
        return list1;
    }
    
    public Matrix getList2(){
        return list2;
    }
    
    public BigDecimal getCorrelation(){
        return correlation;
    }
    
    public BigDecimal getMaxXReal(){
        return maxXReal;
    }
    public BigDecimal getMaxYReal(){
        return maxYReal;
    }
    
    public BigDecimal getMaxTime(){
        return maxTime;
    }
    
    public BigDecimal getTimeRange(){
        return timeRange;
    }
    
    public BigDecimal getMaxXGraph(){
        return maxXGraph;
    }
    public BigDecimal getMaxYGraph(){
        return maxYGraph;
    }
    public BigDecimal getMinXReal(){
        return minXReal;
    }
    public BigDecimal getMinYReal(){
        return minYReal;
    }
    public BigDecimal getTheMaxReal(){
        return theMax;
    }
    
    public BigDecimal getMinXGraph(){
        return minXGraph;
    }
    public BigDecimal getMinYGraph(){
        return minYGraph;
    }
    
    public BigDecimal getXUnit(){
        return unitX;
    }
    public BigDecimal getYUnit(){
        return unitY;
    }
    
    public String getFormula(){
        return formula;
    }
    
    public String getStd(){
        return std;
    }
    
    public String getDotSize(){
        return dotSize;
    }
    
    public BigDecimal getRateMutation(){
        return rateMutation;
    }
    
    public BigDecimal getInvRate(){
        return invRate;
    }
    
    public BigDecimal[] getIntercept(){
        return intercept;
    }
    public BigDecimal[] getSlope(){
        return slope;
    }
    public BigDecimal getMean(){
        return meanStat;
    }
    public BigDecimal getXStd(){
        return xStd;
    }
    
    
    private void initTime(){
        
        plotList = new PlotList();
        BigDecimal sum1=new BigDecimal("0");
        BigDecimal sum2=new BigDecimal("0");
        theMax = new BigDecimal("0");
        maxXReal = new BigDecimal("0");
        maxYReal = new BigDecimal("0");
        minXReal = new BigDecimal("0");
        minYReal=new BigDecimal("0");
        minNotZeroX = new BigDecimal("1000");
        minNotZeroY = new BigDecimal("1000");
        int population=0; //achtung couple 104-104=0...
        int timey=0;
        
        // look for max distance
        for(int i=0;i<list1.getNames().length;i++){
            for(int j=i+1;j<list1.getNames().length;j++){
                BigDecimal distance = list1.getMatrix()[i][j];
                if(distance.compareTo(maxXReal)==1) maxXReal=distance;
                if(distance.compareTo(minXReal)==-1 && distance.compareTo(new BigDecimal("0"))!=0) minNotZeroX=distance;
            }
        }
        //look for min time and max time
        for(int i=0;i<list1.getDate().length;i++){
            if(new BigDecimal(list1.getDate()[i]).compareTo(maxTime)==1) maxTime=new BigDecimal(list1.getDate()[i]);
            if(new BigDecimal(list1.getDate()[i]).compareTo(minTime)==-1) minTime=new BigDecimal(list1.getDate()[i]);
            
        }
        timeRange=maxTime.subtract(minTime);
        maxXGraph=maxXReal;
        minXGraph=minXReal;
        unitX=new BigDecimal("0");
        unitY=new BigDecimal("0");
        formula="(x-y)";
        std="3";
        dotSize="3";
        
        BigDecimal sumStat=new BigDecimal("0");
        int pos=0;
        // do coord for plot
        for(int i=0;i<list1.getNames().length;i++){
            for(int j=i+1;j<list1.getNames().length;j++){
                //if(i!=j){
                BigDecimal distance = list1.getMatrix()[i][j];
                population++;
                sum1=sum1.add(distance);
                String name1=list1.getNames()[i];
                String name2=list1.getNames()[j];
                int one=0;
                int two=0;
                for(int k=0;k<list1.getNames().length;k++){
                    if(name1.compareTo(list1.getNames()[k])==0)one=k;
                    if(name2.compareTo(list1.getNames()[k])==0)two=k;
                }
                BigDecimal date1=new BigDecimal(list1.getDate()[one]);
                BigDecimal date2=new BigDecimal(list1.getDate()[two]);
                BigDecimal dateDiff=date1.subtract(date2);
                
                if(dateDiff.compareTo(new BigDecimal("0"))==-1) dateDiff=new BigDecimal("-1").multiply(dateDiff);
                if(dateDiff.compareTo(minYReal)==-1 && dateDiff.compareTo(new BigDecimal("0"))!=0) minNotZeroY=dateDiff;
                if(dateDiff.compareTo(maxYReal)==1) maxYReal=dateDiff;
                
                sum2=sum2.add(dateDiff);
                BigDecimal dateDiffPlot=dateDiff.multiply(LINELENGTH_BIG);
                dateDiffPlot=dateDiffPlot.divide(timeRange,1);
                int dateDiffPlotInt=dateDiffPlot.intValue();
                
                
                BigDecimal distancePlot=distance.multiply(LINELENGTH_BIG);
                distancePlot=distancePlot.divide(maxXReal,1);
                int distancePlotInt=distancePlot.intValue();
                plotList.add(name1,name2,distancePlotInt,dateDiffPlotInt,distance,dateDiff);
                
                BigDecimal stat=new BigDecimal(computeEach(formula,distance,dateDiff));
                sumStat=sumStat.add(stat);
                ((PlotCoord)plotList.getList().elementAt(pos)).setStatValue(stat);
                pos++;
                //}
            }
        }
        maxYGraph=maxYReal;
        minYGraph=minYReal;
        BigDecimal mean1=MathStat.mean(sum1,population);
        BigDecimal mean2=MathStat.mean(sum2,population);
        correlation=MathStat.correlation(plotList, mean1 ,mean2);
        
        meanStat=MathStat.mean(sumStat,plotList.getNbPosition());
        xStd=MathStat.stdDev(plotList,meanStat).multiply(new BigDecimal(std));
        
        slope=MathStat.slope(plotList);
        intercept=MathStat.intercept(plotList,slope);
        
        //        sbl1=list1.getSbl();
        //        sbl2=list2.getSbl();
        //        rateMutation=sbl1.divide(sbl2,3,3);
        //        invRate=new BigDecimal(1.0000).divide(sbl1.divide(sbl2,3),3,3);
    }
    
    
    private void init(){
        plotList = new PlotList();
        BigDecimal[][] matrix1=list1.getMatrix();
        BigDecimal[][] matrix2=list2.getMatrix();
        reorder();
        matrix2=list2.getMatrix();
        int population=0;
        
        theMax = new BigDecimal("0");
        maxXReal = new BigDecimal("0");
        maxYReal = new BigDecimal("0");
        minXReal = new BigDecimal("0");
        minYReal = new BigDecimal("0");
        minNotZeroX = new BigDecimal("1000");
        minNotZeroY = new BigDecimal("1000");
        BigDecimal sum1=new BigDecimal("0");
        BigDecimal sum2=new BigDecimal("0");
        
        // look for max distance for X and Y
        // look for the min distance for replacing a distance=0
        for(int i=0;i<list1.getNames().length;i++){
            for(int j=i+1;j<list1.getNames().length;j++){
                BigDecimal one = matrix1[i][j];
                BigDecimal two = matrix2[i][j];
                population++;
                if(one.compareTo(maxXReal)==1) maxXReal=one;
                if(two.compareTo(maxYReal)==1) maxYReal=two;
                if(one.compareTo(minNotZeroX)==-1 && one.compareTo(new BigDecimal("0"))!=0) minNotZeroX=one;
                if(two.compareTo(minNotZeroY)==-1 && two.compareTo(new BigDecimal("0"))!=0) minNotZeroY=two;
                sum1=sum1.add(one);
                sum2=sum2.add(two);
            }
        }
        minXGraph=minXReal;
        minYGraph=minYReal;
        if(maxXReal.compareTo(maxYReal)==1) theMax=maxXReal;
        else theMax=maxYReal;
        maxXGraph=theMax;
        maxYGraph=theMax;
        
        unitX=new BigDecimal("0");
        unitY=new BigDecimal("0");
        formula="(x-y)";
        std="3";
        dotSize="3";
        
        BigDecimal mean1=MathStat.mean(sum1,population);
        BigDecimal mean2=MathStat.mean(sum2,population);
        
        correlation=MathStat.correlation(list1, list2, mean1 ,mean2);
        
        BigDecimal sbl1=list1.getSBL();
        BigDecimal sbl2=list2.getSBL();
        if( sbl1!=null && sbl2!=null){
          rateMutation=sbl1.divide(sbl2,3,3);
          invRate=new BigDecimal(1.0000).divide(sbl1.divide(sbl2,3),3,3);
        }
        int pos=0;
        // do coord
        BigDecimal sumStat=new BigDecimal("0");
        for(int i=0;i<list1.getNames().length;i++){
            for(int j=i+1;j<list1.getNames().length;j++){
                BigDecimal oneBig = matrix1[i][j];
                BigDecimal twoBig = matrix2[i][j];
                
                String name1=list1.getNames()[i];
                String name2=list1.getNames()[j];
                
                BigDecimal stat=new BigDecimal(computeEach(formula,oneBig,twoBig));
                sumStat=sumStat.add(stat);
                
                
                //plot
                BigDecimal two=twoBig.multiply(LINELENGTH_BIG);
                two=two.divide(theMax,1); // instead of theMax maxYGraph
                BigDecimal one=oneBig.multiply(LINELENGTH_BIG);
                one=one.divide(theMax,1);// instead of theMax maxXGraph
                int oneI=one.intValue();
                int twoI=two.intValue();
                plotList.add(name1,name2,oneI,twoI,oneBig,twoBig);
                ((PlotCoord)plotList.getList().elementAt(pos)).setStatValue(stat);
                pos++;
            }
        }
        meanStat=MathStat.mean(sumStat,plotList.getNbPosition());
        xStd=MathStat.stdDev(plotList,meanStat).multiply(new BigDecimal(std));
        slope=MathStat.slope(plotList);
        intercept=MathStat.intercept(plotList,slope);
//        System.out.println("Intercept "+intercept);
//        System.out.println("Slope "+slope);
    }
    
    private void alterCoordinates(){
        int pos=0;
        if(list2==null){
            for(int i=0;i<list1.getNames().length;i++){
                for(int j=i+1;j<list1.getNames().length;j++){
                    String name1=list1.getNames()[i];
                    String name2=list1.getNames()[j];
                    int one=0;
                    int two=0;
                    for(int k=0;k<list1.getNames().length;k++){
                        if(name1.compareTo(list1.getNames()[k])==0)one=k;
                        if(name2.compareTo(list1.getNames()[k])==0)two=k;
                    }
                    BigDecimal distance = list1.getMatrix()[i][j];
//                    int date1=new Integer(list1.getDate()[one]).intValue();
//                    int date2=new Integer(list1.getDate()[two]).intValue();
//                    int dateDiff=date1-date2;
//                    if(dateDiff<0) dateDiff=(-1)*dateDiff;
                    
                    
                    BigDecimal date1=new BigDecimal(list1.getDate()[one]);
                    BigDecimal date2=new BigDecimal(list1.getDate()[two]);
                    BigDecimal dateDiff=date1.subtract(date2);
                    if(dateDiff.compareTo(new BigDecimal("0"))==-1) dateDiff=new BigDecimal("-1").multiply(dateDiff);
                   
                    
                    if(distance.compareTo(maxXGraph)==1 || distance.compareTo(minXGraph)==-1
                            || dateDiff.compareTo(maxYGraph)==1 || dateDiff.compareTo(minYGraph)==-1){
                        ((PlotCoord)(plotList.getList().elementAt(pos))).setX(-1);
                        ((PlotCoord)(plotList.getList().elementAt(pos))).setY(-1);
                    } else{
                        distance=distance.subtract(minXGraph);
                        BigDecimal distancePlot=distance.multiply(LINELENGTH_BIG);
                        BigDecimal maxminX=maxXGraph.subtract(minXGraph);
                        distancePlot=distancePlot.divide(maxminX,1);
                        int distancePlotInt=distancePlot.intValue();
                        
                        BigDecimal dateDiffPlot=dateDiff.subtract(minYGraph);
                        dateDiffPlot=dateDiffPlot.multiply(LINELENGTH_BIG);
                        BigDecimal maxminY=maxYGraph.subtract(minYGraph);
                        dateDiffPlot=dateDiffPlot.divide(maxminY,1);
                        ((PlotCoord)(plotList.getList().elementAt(pos))).setX(distancePlotInt);
                        ((PlotCoord)(plotList.getList().elementAt(pos))).setY(dateDiffPlot.intValue());
                    }
                    pos++;
                }
            }
        }
        // Plotpanel
        else{
            for(int i=0;i<list1.getNames().length;i++){
                for(int j=i+1;j<list1.getNames().length;j++){
                    
                    BigDecimal[][] matrix1=list1.getMatrix();
                    BigDecimal[][] matrix2=list2.getMatrix();
                    BigDecimal one = matrix1[i][j];
                    BigDecimal two = matrix2[i][j];
                    if(one.compareTo(maxXGraph)==1 || one.compareTo(minXGraph)==-1
                            || two.compareTo(maxYGraph)==1 || two.compareTo(minYGraph)==-1){
                        ((PlotCoord)(plotList.getList().elementAt(pos))).setX(-1);
                        ((PlotCoord)(plotList.getList().elementAt(pos))).setY(-1);
                    } else{
                        one=one.subtract(minXGraph);
                        one=one.multiply(LINELENGTH_BIG);
                        BigDecimal maxMinX=maxXGraph.subtract(minXGraph);
                        one=one.divide(maxMinX,1);
                        //System.out.println("MAXMINX "+maxMinX);
                        two=two.subtract(minYGraph);
                        two=two.multiply(LINELENGTH_BIG);
                        BigDecimal maxMinY=maxYGraph.subtract(minYGraph);
                        two=two.divide(maxMinY,1);
                        //System.out.println("MAXMINY "+maxMinY);
                        
                        int oneI=one.intValue();
                        int twoI=two.intValue();
                        ((PlotCoord)(plotList.getList().elementAt(pos))).setX(oneI);
                        ((PlotCoord)(plotList.getList().elementAt(pos))).setY(twoI);
                    }
                    pos++;
                }
            }
        }
        //debug();
    }
    
    private void reorder(){
        String[] names1=list1.getNames();
        String[] names2=list2.getNames();
        
        BigDecimal [][] temp = new BigDecimal[names1.length][names1.length];
        BigDecimal [][] temp2 = new BigDecimal[names1.length][names1.length];
        boolean diff=false;
        boolean doOrder=false;
        for(int i=0;i<names1.length;i++) {
            if(!names1[i].equals(names2[i])){diff=true;break;}
        }
        if(diff){
            int result = JOptionPane.showConfirmDialog(null, "Do you need to reorder the data?","",JOptionPane.YES_NO_OPTION);
            if(result == JOptionPane.YES_OPTION){
                doOrder=true;
            }
        }
        if(doOrder){
            list2=list2.reOrder(names1);
//            // Horizontal
//            for(int j=0;j<names1.length;j++){
//                for(int x=0;x<names2.length;x++){
//                    if(names1[j].equals(names2[x])){
//                        for(int z=0;z<names1.length;z++){
//                            temp[z][j]=list2.getMatrix()[z][x];
//                        }
//                        break;
//                    }
//                }
//            }
//            // Vertical
//            for(int j=0;j<names1.length;j++){
//                for(int x=0;x<names2.length;x++){
//                    if(names1[j].equals(names2[x])){
//                        for(int z=0;z<names1.length;z++){
//                            temp2[j][z]=temp[x][z];
//                        }
//                        break;
//                    }
//                }
//            }
//
//            list2.setMatrix(temp2);
//            list2.setNames(list1.getNames());
        }
        
    }
    
    public void updateScaleX(BigDecimal maxGraph,BigDecimal minGraph,BigDecimal unit){
        this.maxXGraph=maxGraph;
        this.minXGraph=minGraph;
        this.unitX=unit;
    }
    
    public void updateScaleY(BigDecimal maxGraph,BigDecimal minGraph,BigDecimal unit){
        this.maxYGraph=maxGraph;
        this.minYGraph=minGraph;
        this.unitY=unit;
        alterCoordinates();
    }
    
    public void updateFormula(String formula){
        this.formula=formula;
        BigDecimal sumStat=new BigDecimal("0");
        
        for(int i=0;i<plotList.getNbPosition();i++){
            BigDecimal one=((PlotCoord)(plotList.getList().elementAt(i))).getXx();
            BigDecimal two=((PlotCoord)(plotList.getList().elementAt(i))).getYy();
            if(two==null) two=((PlotCoord)(plotList.getList().elementAt(i))).getYy();
            BigDecimal stat=new BigDecimal(computeEach(formula,one,two));
            sumStat=sumStat.add(stat);
            ((PlotCoord)plotList.getList().elementAt(i)).setStatValue(stat);
        }
        meanStat=MathStat.mean(sumStat,plotList.getNbPosition());
        xStd=MathStat.stdDev(plotList,meanStat).multiply(new BigDecimal(std));
    }
    
    public void updateSTD(String std){
        this.std=std;
        xStd=MathStat.stdDev(plotList,meanStat).multiply(new BigDecimal(std));
    }
    
    public void updateProperties(String dotSize){
        this.dotSize=dotSize;
    }
    
    
    private String computeEach(String str, BigDecimal one, BigDecimal two){
        Stack stack = new Stack();
        for(int j=0;j<str.length();j++){
            String car=str.substring(j,j+1);
            BigDecimal ft=new BigDecimal("-1");
            BigDecimal sd=new BigDecimal("-1");
            String op="";
            String top="";
            if(!car.equals(")")){
                stack.push(car);
                //              System.out.println("push not ) "+car);
            } else{
                //              System.out.println("push )");
                while(true){
                    top=(String)stack.pop();
                    //                  System.out.println("on top "+top);
                    if(top.equals("(")){
                        break;
                    }
                    if(top.equals("+") ||top.equals("-") ||top.equals("*") ||top.equals("/")){
                        op=top;
                        //                      System.out.println("found op "+op);
                    } else{
                        if(top.equals("x")){
                            //                          System.out.println("found x "+one);
                            if(ft.equals(new BigDecimal("-1")))ft=one;
                            else sd=one;
                        } else if((top.equals("y"))){
                            //                          System.out.println("found y "+two);
                            if(ft.equals(new BigDecimal("-1")))ft=two;
                            else sd=two;
                        } else{
                            if(ft.equals(new BigDecimal("-1"))){
                                ft=new BigDecimal(top);
                                //                          System.out.println("found nb "+ft);
                            } else{
                                sd=new BigDecimal(top);
                                //                          System.out.println("found nb "+sd);
                            }
                        }
                    }
                }
                if(op.equals("+")) stack.push((ft.add(sd)).toString());
                else if(op.equals("-")) stack.push((ft.subtract(sd)).toString());
                else if(op.equals("*")) stack.push((ft.multiply(sd)).toString());
                else if(op.equals("/")){
                    if(sd.compareTo(new BigDecimal("0"))==0)sd=new BigDecimal("0.000001");
                    System.out.println(sd);
                    stack.push((ft.divide(sd,3)).toString());
                }
                //              System.out.println("result "+stack.peek());
                
            }
            
        }
        String result =stack.pop().toString();
        return result;
    }
    
    public void addOptionListener(OptionListener l) {
        listenerList.add(OptionListener.class, l);
    }
    public void fireUpdated() {
        fireChanged(new EventObject(this));
    }
    
    public void fireChanged(EventObject e) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length-2; i>=0; i-=2) {
            if (listeners[i]==OptionListener.class) {
                ((OptionListener)listeners[i+1]).plotChanged(e);
            }
        }
    }
    public EventListener[] getListeners(Class listenerType) {
        return listenerList.getListeners(listenerType);
    }
    
    private void debug(){
        System.out.println("---------------------------------------------------");
        System.out.println("GRAPH MAX X: "+maxXGraph+" MAX Y: "+maxYGraph);
        System.out.println("GRAPH MIN X: "+minXGraph+" MIN Y: "+minYGraph);
        System.out.println("REAL MAX X: "+maxXReal+" MAX Y: "+maxYReal);
        System.out.println("REAL MIN X: "+minXReal+" MIN Y: "+minYReal);
        System.out.println("THE MAX: "+theMax);
        //System.out.println();
        
    }
}
